/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.model.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import org.eclipse.emf.texo.server.model.request.ActionType;
import org.eclipse.emf.texo.server.model.request.QueryReferingObjectsType;
import org.eclipse.emf.texo.server.model.request.QueryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentRootMixedFeatureGroup {
    @Basic
    @Enumerated(value=EnumType.STRING)
    private Feature feature = null;
    @Basic(optional=true)
    @Lob
    private String text;
    @Basic(optional=true)
    @Lob
    private String cDATA;
    @Basic(optional=true)
    @Lob
    private String comment;
    private ActionType action;
    private QueryType query;
    private QueryReferingObjectsType queryReferingObjects;

    public static <T> List<T> createUnmodifiableValueList(List<DocumentRootMixedFeatureGroup> featureGroup, Feature filterByFeature) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != filterByFeature) continue;
            result.add(group.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> T getSingleFeatureMapValue(List<DocumentRootMixedFeatureGroup> featureGroup, Feature filterByFeature) {
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != filterByFeature) continue;
            return (T)group.getValue();
        }
        return null;
    }

    public static void setSingleFeatureMapValue(List<DocumentRootMixedFeatureGroup> featureGroup, Feature feature, Object value) {
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != feature) continue;
            group.setValue(feature, value);
            return;
        }
        DocumentRootMixedFeatureGroup entry = new DocumentRootMixedFeatureGroup();
        entry.setValue(feature, value);
        featureGroup.add(entry);
    }

    public static List<DocumentRootMixedFeatureGroup> createFeatureGroupList(Feature feature, List<?> values) {
        ArrayList<DocumentRootMixedFeatureGroup> result = new ArrayList<DocumentRootMixedFeatureGroup>();
        for (Object value : values) {
            DocumentRootMixedFeatureGroup group = new DocumentRootMixedFeatureGroup();
            group.setValue(feature, value);
            result.add(group);
        }
        return result;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.setFeature(Feature.TEXT);
    }

    public String getCDATA() {
        return this.cDATA;
    }

    public void setCDATA(String newCDATA) {
        this.cDATA = newCDATA;
        this.setFeature(Feature.CDATA);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        this.comment = newComment;
        this.setFeature(Feature.COMMENT);
    }

    public ActionType getAction() {
        return this.action;
    }

    public void setAction(ActionType newAction) {
        this.action = newAction;
        this.setFeature(Feature.ACTION);
    }

    public QueryType getQuery() {
        return this.query;
    }

    public void setQuery(QueryType newQuery) {
        this.query = newQuery;
        this.setFeature(Feature.QUERY);
    }

    public QueryReferingObjectsType getQueryReferingObjects() {
        return this.queryReferingObjects;
    }

    public void setQueryReferingObjects(QueryReferingObjectsType newQueryReferingObjects) {
        this.queryReferingObjects = newQueryReferingObjects;
        this.setFeature(Feature.QUERYREFERINGOBJECTS);
    }

    public Object getValue() {
        switch (this.getFeature()) {
            case TEXT: {
                return this.getText();
            }
            case CDATA: {
                return this.getCDATA();
            }
            case COMMENT: {
                return this.getComment();
            }
            case ACTION: {
                return this.getAction();
            }
            case QUERY: {
                return this.getQuery();
            }
            case QUERYREFERINGOBJECTS: {
                return this.getQueryReferingObjects();
            }
        }
        throw new IllegalStateException("Feature kind " + (Object)((Object)this.getFeature()) + " is not supported for this object " + this);
    }

    public void setValue(Feature feature, Object value) {
        switch (feature) {
            case TEXT: {
                this.setText((String)value);
                break;
            }
            case CDATA: {
                this.setCDATA((String)value);
                break;
            }
            case COMMENT: {
                this.setComment((String)value);
                break;
            }
            case ACTION: {
                this.setAction((ActionType)value);
                break;
            }
            case QUERY: {
                this.setQuery((QueryType)value);
                break;
            }
            case QUERYREFERINGOBJECTS: {
                this.setQueryReferingObjects((QueryReferingObjectsType)value);
                break;
            }
            default: {
                throw new IllegalStateException("Feature kind " + (Object)((Object)this.getFeature()) + " is not supported for this object " + this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        TEXT,
        CDATA,
        COMMENT,
        ACTION,
        QUERY,
        QUERYREFERINGOBJECTS;

    }
}

