/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.json.EMFJSONConverter;
import org.eclipse.emf.texo.json.JSONModelConverter;
import org.eclipse.emf.texo.json.ModelJSONConverter;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.server.service.ServiceContext;
import org.eclipse.emf.texo.store.ObjectStore;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONServiceContext
extends ServiceContext {
    public JSONServiceContext() {
        this.setResponseContentType("application/json;charset=UTF-8");
    }

    @Override
    public void setObjectStore(ObjectStore objectStore) {
        objectStore.setUseWebServiceUriFormat(this.isUseWebServiceUriFormat());
        super.setObjectStore(objectStore);
    }

    @Override
    protected String convertToResultFormat(Object object) {
        ModelJSONConverter converter = (ModelJSONConverter)ComponentProvider.getInstance().newInstance(ModelJSONConverter.class);
        if (JSONServiceContext.isInTexoTestRun()) {
            converter.setSkipVolatileEFeatures(true);
        }
        if (this.getRequestParameters().containsKey("childLevels")) {
            try {
                converter.setMaxChildLevelsToConvert(Integer.parseInt((String)this.getRequestParameters().get("childLevels")));
            }
            catch (NumberFormatException e) {
                converter.setMaxChildLevelsToConvert(2);
            }
        } else {
            converter.setMaxChildLevelsToConvert(2);
        }
        converter.setObjectResolver((ObjectResolver)this.getObjectStore());
        Object jsonObject = converter.convert(object);
        return jsonObject.toString();
    }

    @Override
    protected String convertToResultFormat(EObject eObject) {
        EMFJSONConverter converter = (EMFJSONConverter)ComponentProvider.getInstance().newInstance(EMFJSONConverter.class);
        if (this.getRequestParameters().containsKey("childLevels")) {
            try {
                converter.setMaxChildLevelsToConvert(Integer.parseInt((String)this.getRequestParameters().get("childLevels")));
            }
            catch (NumberFormatException e) {
                converter.setMaxChildLevelsToConvert(2);
            }
        } else {
            converter.setMaxChildLevelsToConvert(2);
        }
        converter.setObjectResolver((ObjectResolver)this.getObjectStore());
        Object jsonObject = converter.convert((Object)eObject);
        return jsonObject.toString();
    }

    @Override
    public List<Object> getRequestData() {
        try {
            ArrayList<Object> resultList;
            String content = this.getRequestContent();
            if (content == null) {
                return Collections.emptyList();
            }
            JSONModelConverter converter = (JSONModelConverter)ComponentProvider.getInstance().newInstance(JSONModelConverter.class);
            converter.setObjectResolver((ObjectResolver)this.getObjectStore());
            content = content.trim();
            if (content.length() == 0) {
                return Collections.emptyList();
            }
            if (content.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(content);
                resultList = converter.convert(jsonArray);
            } else {
                JSONObject jsonObject = new JSONObject(content);
                Object result = converter.convert(jsonObject);
                resultList = new ArrayList<Object>();
                resultList.add(result);
            }
            return resultList;
        }
        catch (JSONException e) {
            throw new RuntimeException(String.valueOf(e.getMessage()) + this.getRequestContent(), e);
        }
    }
}

