/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.converter.EMFModelConverter;
import org.eclipse.emf.texo.converter.ModelEMFConverter;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.server.store.EntityManagerObjectStore;
import org.eclipse.emf.texo.server.store.EntityManagerProvider;
import org.eclipse.emf.texo.store.EObjectStore;
import org.eclipse.emf.texo.store.ObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPersistenceService
extends EObjectStore
implements TexoComponent {
    private EntityManagerFactory entityManagerFactory;

    /*
     * Unable to fully structure code
     */
    public void persist(List<EObject> toInsert, List<EObject> toUpdate, List<EObject> toDelete) {
        block10: {
            os = this.getObjectStore();
            err = true;
            os.begin();
            try {
                converter = (EMFModelConverter)ComponentProvider.getInstance().newInstance(EMFModelConverter.class);
                converter.setUriResolver((ObjectResolver)os);
                allObjects = new ArrayList<E>();
                i = 0;
                objectMapping = new HashMap<E, InternalEObject>();
                for (E object : converter.convert(toInsert)) {
                    allObjects.add(object);
                    os.insert(object);
                    objectMapping.put(object, (InternalEObject)toInsert.get(i));
                    ++i;
                }
                i = 0;
                for (E object : converter.convert(toUpdate)) {
                    allObjects.add(object);
                    os.update(object);
                    objectMapping.put(object, (InternalEObject)toUpdate.get(i));
                    ++i;
                }
                i = 0;
                for (E delete : converter.convert(toDelete)) {
                    os.remove(delete);
                    this.removeFromCache(this.toUri(toDelete.get(i++)));
                }
                os.flush();
                m2eConverter = this.createModelEMFConverter();
                m2eConverter.setObjectMapping(objectMapping);
                result = m2eConverter.convert(allObjects);
                for (EObject eObject : result) {
                    if (!toInsert.contains(eObject) && !toUpdate.contains(eObject)) {
                        throw new IllegalStateException("Invalid conversion");
                    }
                    this.addToCache(eObject);
                }
                err = false;
            }
            finally {
                if (err) {
                    os.rollback();
                    break block10;
                }
                os.commit();
                ** for (delete : toDelete)
            }
lbl-1000:
            // 1 sources

            {
                this.deleted(delete);
                continue;
            }
        }
        os.close();
    }

    public List<EObject> query(String qryStr, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        ObjectStore os = this.getObjectStore();
        boolean err = true;
        os.begin();
        try {
            List objects = os.query(qryStr, namedParameters, firstResult, maxResults);
            ModelEMFConverter converter = this.createModelEMFConverter();
            List result = converter.convert(objects);
            err = false;
            for (EObject resultObject : result) {
                this.addToCache(resultObject);
            }
            List list = result;
            return list;
        }
        finally {
            if (err) {
                os.rollback();
            } else {
                os.commit();
            }
            os.close();
        }
    }

    public long count(String qry, Map<String, Object> namedParameters) {
        ObjectStore os = this.getObjectStore();
        boolean err = true;
        os.begin();
        try {
            long result = os.count(qry, namedParameters);
            err = false;
            long l = result;
            return l;
        }
        finally {
            if (err) {
                os.rollback();
            } else {
                os.commit();
            }
            os.close();
        }
    }

    protected ObjectStore getObjectStore() {
        EntityManagerObjectStore emStore = (EntityManagerObjectStore)((Object)ComponentProvider.getInstance().newInstance(EntityManagerObjectStore.class));
        emStore.setEntityManager(this.getEntityManager());
        emStore.setUri(this.getUri());
        return emStore;
    }

    protected synchronized EntityManager getEntityManager() {
        if (this.entityManagerFactory == null) {
            return EntityManagerProvider.getInstance().getEntityManager();
        }
        return this.entityManagerFactory.createEntityManager();
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    protected EObject loadEObject(EClass eClass, String idString) {
        ObjectStore os = this.getObjectStore();
        boolean err = true;
        os.begin();
        try {
            Object id = IdProvider.getInstance().convertIdStringToId(eClass, idString);
            Object target = os.get(eClass, id);
            if (target == null) {
                return null;
            }
            ModelEMFConverter converter = this.createModelEMFConverter();
            List result = converter.convert(Collections.singletonList(target));
            err = false;
            EObject eObject = (EObject)result.get(0);
            return eObject;
        }
        finally {
            if (err) {
                os.rollback();
            } else {
                os.commit();
            }
            os.close();
        }
    }

    public void refresh(EObject eObject) {
        ObjectStore os = this.getObjectStore();
        boolean err = true;
        os.begin();
        try {
            Object target = os.resolveFromEObject(eObject);
            HashMap<Object, InternalEObject> objectMapping = new HashMap<Object, InternalEObject>();
            objectMapping.put(target, (InternalEObject)eObject);
            ModelEMFConverter converter = this.createModelEMFConverter();
            converter.setObjectMapping(objectMapping);
            List result = converter.convert(Collections.singletonList(target));
            if (result.get(0) != eObject) {
                throw new IllegalStateException("Object not refreshed, different object resolved back expected " + eObject + " got " + result.get(0));
            }
            err = false;
        }
        finally {
            if (err) {
                os.rollback();
            } else {
                os.commit();
            }
            os.close();
        }
    }

    public List<EObject> getReferingObjects(EObject eTarget, int maxResult, boolean includeContainerReferences) {
        ObjectStore os = this.getObjectStore();
        boolean err = true;
        os.begin();
        try {
            Object id = eTarget.eGet((EStructuralFeature)IdProvider.getInstance().getIdEAttribute(eTarget.eClass()));
            Object target = os.get(eTarget.eClass(), id);
            List objects = os.getReferingObjects(target, maxResult, includeContainerReferences);
            ModelEMFConverter converter = this.createModelEMFConverter();
            List result = converter.convert(objects);
            err = false;
            List list = result;
            return list;
        }
        finally {
            if (err) {
                os.rollback();
            } else {
                os.commit();
            }
            os.close();
        }
    }

    protected ModelEMFConverter createModelEMFConverter() {
        ModelEMFConverter converter = (ModelEMFConverter)ComponentProvider.getInstance().newInstance(ModelEMFConverter.class);
        converter.setObjectResolver((ObjectResolver)this);
        converter.setMaxChildLevelsToConvert(1);
        return converter;
    }
}

