/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml.model.texoextensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentRootMixedFeatureGroup {
    private Feature feature = null;
    private String text;
    private String cDATA;
    private String comment;

    public static <T> List<T> createUnmodifiableValueList(List<DocumentRootMixedFeatureGroup> featureGroup, Feature filterByFeature) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != filterByFeature) continue;
            result.add(group.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> T getSingleFeatureMapValue(List<DocumentRootMixedFeatureGroup> featureGroup, Feature filterByFeature) {
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != filterByFeature) continue;
            return (T)group.getValue();
        }
        return null;
    }

    public static List<DocumentRootMixedFeatureGroup> createFeatureGroupList(Feature feature, List<?> values) {
        ArrayList<DocumentRootMixedFeatureGroup> result = new ArrayList<DocumentRootMixedFeatureGroup>();
        for (Object value : values) {
            DocumentRootMixedFeatureGroup group = new DocumentRootMixedFeatureGroup();
            group.setValue(feature, value);
            result.add(group);
        }
        return result;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.setFeature(Feature.TEXT);
    }

    public String getCDATA() {
        return this.cDATA;
    }

    public void setCDATA(String newCDATA) {
        this.cDATA = newCDATA;
        this.setFeature(Feature.CDATA);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        this.comment = newComment;
        this.setFeature(Feature.COMMENT);
    }

    public Object getValue() {
        switch (this.getFeature()) {
            case TEXT: {
                return this.getText();
            }
            case CDATA: {
                return this.getCDATA();
            }
            case COMMENT: {
                return this.getComment();
            }
        }
        throw new IllegalStateException("Feature kind " + (Object)((Object)this.getFeature()) + " is not supported for this object " + this);
    }

    public void setValue(Feature feature, Object value) {
        switch (feature) {
            case TEXT: {
                this.setText((String)value);
                break;
            }
            case CDATA: {
                this.setCDATA((String)value);
                break;
            }
            case COMMENT: {
                this.setComment((String)value);
                break;
            }
            default: {
                throw new IllegalStateException("Feature kind " + (Object)((Object)this.getFeature()) + " is not supported for this object " + this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        TEXT,
        CDATA,
        COMMENT;

    }
}

