/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.resolver.DefaultObjectResolver;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModelConverter<T>
implements TexoComponent {
    private List<T> proxyObjects = new ArrayList<T>();
    private List<T> nonProxiedObjects = new ArrayList<T>();
    private boolean skipVolatileEFeatures = false;
    private boolean convertNonContainedReferencedObjects = false;
    private int maxChildLevelsToConvert = Integer.MAX_VALUE;
    private ObjectResolver objectResolver = ComponentProvider.getInstance().newInstance(DefaultObjectResolver.class);

    protected void doBaseActions(List<T> objects) {
        if (!(this.objectResolver == null || this.convertNonContainedReferencedObjects && this.maxChildLevelsToConvert >= Integer.MAX_VALUE)) {
            this.computeProxyObjects(objects);
        }
        this.proxyObjects.removeAll(this.nonProxiedObjects);
    }

    protected void computeProxyObjects(List<T> objects) {
        for (T o : objects) {
            this.traverseEReferencesForProxyDetermination(o, 0);
        }
    }

    protected void traverseEReferencesForProxyDetermination(T object, int level) {
        if (this.nonProxiedObjects.contains(object) || this.nonProxiedObjects.contains(object)) {
            return;
        }
        if (object.getClass().isArray()) {
            int i = 0;
            while (i < Array.getLength(object)) {
                Object value = Array.get(object, i);
                if (this.isModelEnabled(value)) {
                    this.traverseEReferencesForProxyDetermination(value, level);
                }
                ++i;
            }
            return;
        }
        this.nonProxiedObjects.add(object);
        boolean proxyChildObjects = level == this.maxChildLevelsToConvert;
        for (EReference eReference : this.eClass(object).getEAllReferences()) {
            Object keyValue;
            Map map;
            Object value;
            if (this.isSkipVolatileEFeatures() && eReference.isVolatile() || this.doSkipNotChangeAbleFeatures() && !eReference.isChangeable() || (value = this.eGet(object, (EStructuralFeature)eReference)) == null) continue;
            if (eReference.isContainment()) {
                if (!proxyChildObjects) {
                    if (value instanceof Collection) {
                        for (Object o : (Collection)value) {
                            this.traverseEReferencesForProxyDetermination(o, level + 1);
                        }
                        continue;
                    }
                    if (value instanceof Map) {
                        map = (Map)value;
                        for (Iterator<Object> key : map.keySet()) {
                            keyValue = map.get(key);
                            if (this.isModelEnabled(key)) {
                                this.traverseEReferencesForProxyDetermination(key, level + 1);
                            }
                            if (!this.isModelEnabled(keyValue)) continue;
                            this.traverseEReferencesForProxyDetermination(keyValue, level + 1);
                        }
                        continue;
                    }
                    this.traverseEReferencesForProxyDetermination(value, level + 1);
                    continue;
                }
            } else if (this.convertNonContainedReferencedObjects) {
                if (value instanceof Collection) {
                    Iterator<Object> key;
                    key = ((Collection)value).iterator();
                    while (key.hasNext()) {
                        Object o;
                        o = key.next();
                        this.traverseEReferencesForProxyDetermination(o, level);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    map = (Map)value;
                    for (Iterator<Object> key : map.keySet()) {
                        keyValue = map.get(key);
                        if (this.isModelEnabled(key)) {
                            this.traverseEReferencesForProxyDetermination(key, level + 1);
                        }
                        if (!this.isModelEnabled(keyValue)) continue;
                        this.traverseEReferencesForProxyDetermination(keyValue, level + 1);
                    }
                    continue;
                }
                this.traverseEReferencesForProxyDetermination(value, level);
                continue;
            }
            if (value instanceof Collection) {
                this.proxyObjects.addAll((Collection)value);
                continue;
            }
            this.proxyObjects.add(value);
        }
    }

    protected abstract EClass eClass(T var1);

    protected abstract Object eGet(T var1, EStructuralFeature var2);

    protected abstract boolean isModelEnabled(Object var1);

    protected URI getProxyId(T target) {
        return this.getObjectResolver().toUri(target);
    }

    protected EDataType getDataTypeOrBaseType(EDataType eDataType) {
        EEnum baseType = ModelUtils.getEnumBaseDataTypeIfObject(eDataType);
        if (baseType != null) {
            return baseType;
        }
        return eDataType;
    }

    public boolean isConvertNonContainedReferencedObjects() {
        return this.convertNonContainedReferencedObjects;
    }

    public void setConvertNonContainedReferencedObjects(boolean convertNonContainedReferencedObjects) {
        this.convertNonContainedReferencedObjects = convertNonContainedReferencedObjects;
    }

    public int getMaxChildLevelsToConvert() {
        return this.maxChildLevelsToConvert;
    }

    public void setMaxChildLevelsToConvert(int maxChildLevelsToConvert) {
        this.maxChildLevelsToConvert = maxChildLevelsToConvert;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver uriResolver) {
        this.objectResolver = uriResolver;
    }

    public List<T> getProxyObjects() {
        return this.proxyObjects;
    }

    public void setProxyObjects(List<T> proxyObjects) {
        this.proxyObjects = proxyObjects;
    }

    public List<T> getNonProxiedObjects() {
        return this.nonProxiedObjects;
    }

    public void setNonProxiedObjects(List<T> nonProxiedObjects) {
        this.nonProxiedObjects = nonProxiedObjects;
    }

    public boolean isSkipVolatileEFeatures() {
        return this.skipVolatileEFeatures;
    }

    public void setSkipVolatileEFeatures(boolean skipVolatileEFeatures) {
        this.skipVolatileEFeatures = skipVolatileEFeatures;
    }

    protected boolean doSkipNotChangeAbleFeatures() {
        return false;
    }
}

