/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.DynamicModelObject;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCopier
implements TexoComponent {
    private Map<Object, Object> sourceTargetMap = new HashMap<Object, Object>();
    private boolean copyChildren = false;
    private boolean copyReferences = false;

    public List<Object> copyAll(List<Object> sourceList) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object source : sourceList) {
            result.add(this.copy(source));
        }
        return result;
    }

    public Object copy(Object source) {
        if (source == null) {
            return null;
        }
        if (this.sourceTargetMap.containsKey(source)) {
            return this.sourceTargetMap.get(source);
        }
        if (source instanceof DynamicModelObject) {
            DynamicModelObject target = ComponentProvider.getInstance().newInstance(DynamicModelObject.class);
            target.setData((DynamicModelObject)source);
            this.sourceTargetMap.put(source, target);
            return target;
        }
        ModelObject<Object> sourceModelObject = ModelResolver.getInstance().getModelObject(source);
        ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(sourceModelObject.eClass().getEPackage().getNsURI());
        Object target = modelPackage.getModelFactory().create(sourceModelObject.eClass());
        ModelObject<Object> targetModelObject = ModelResolver.getInstance().getModelObject(target);
        this.sourceTargetMap.put(source, target);
        for (EStructuralFeature eFeature : sourceModelObject.eClass().getEAllStructuralFeatures()) {
            if (eFeature.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
                this.copyFeatureMap(sourceModelObject, targetModelObject, eFeature);
                continue;
            }
            if (ModelUtils.isEMap(eFeature)) {
                this.copyMap(sourceModelObject, targetModelObject, (EReference)eFeature);
                continue;
            }
            if (eFeature.isMany()) {
                if (eFeature instanceof EAttribute) {
                    this.copyManyEAttribute(sourceModelObject, targetModelObject, (EAttribute)eFeature);
                    continue;
                }
                this.copyManyEReference(sourceModelObject, targetModelObject, (EReference)eFeature);
                continue;
            }
            if (eFeature instanceof EAttribute) {
                this.copySingleEAttribute(sourceModelObject, targetModelObject, (EAttribute)eFeature);
                continue;
            }
            this.copySingleEReference(sourceModelObject, targetModelObject, (EReference)eFeature);
        }
        return target;
    }

    protected void copyManyEAttribute(ModelObject<Object> source, ModelObject<Object> target, EAttribute eAttribute) {
        for (Object value : (Collection)source.eGet((EStructuralFeature)eAttribute)) {
            target.eAddTo((EStructuralFeature)eAttribute, value);
        }
    }

    protected void copySingleEAttribute(ModelObject<Object> source, ModelObject<Object> target, EAttribute eAttribute) {
        target.eSet((EStructuralFeature)eAttribute, source.eGet((EStructuralFeature)eAttribute));
    }

    protected void copyManyEReference(ModelObject<Object> source, ModelObject<Object> target, EReference eReference) {
        for (Object value : (Collection)source.eGet((EStructuralFeature)eReference)) {
            if (eReference.isContainment() && this.copyChildren) {
                target.eAddTo((EStructuralFeature)eReference, this.copy(value));
                continue;
            }
            if (!eReference.isContainment() && this.copyReferences) {
                target.eAddTo((EStructuralFeature)eReference, this.copy(value));
                continue;
            }
            target.eAddTo((EStructuralFeature)eReference, value);
        }
    }

    protected void copySingleEReference(ModelObject<Object> source, ModelObject<Object> target, EReference eReference) {
        Object value = source.eGet((EStructuralFeature)eReference);
        if (eReference.isContainment() && this.copyChildren) {
            target.eSet((EStructuralFeature)eReference, this.copy(value));
        } else if (!eReference.isContainment() && this.copyReferences) {
            target.eSet((EStructuralFeature)eReference, this.copy(value));
        } else {
            target.eSet((EStructuralFeature)eReference, value);
        }
    }

    protected void copyMap(ModelObject<Object> source, ModelObject<Object> target, EReference eReference) {
        Map sourceMap = (Map)source.eGet((EStructuralFeature)eReference);
        Map targetMap = (Map)target.eGet((EStructuralFeature)eReference);
        EClass mapEClass = eReference.getEReferenceType();
        EStructuralFeature valueFeature = mapEClass.getEStructuralFeature("value");
        EStructuralFeature keyFeature = mapEClass.getEStructuralFeature("key");
        boolean copyKey = keyFeature instanceof EReference && this.copyReference((EReference)keyFeature);
        boolean copyValue = valueFeature instanceof EReference && this.copyReference((EReference)valueFeature);
        for (Object key : sourceMap.keySet()) {
            Object value = sourceMap.get(key);
            if (copyKey) {
                key = this.copy(key);
            }
            if (copyValue) {
                value = this.copy(value);
            }
            targetMap.put(key, value);
        }
    }

    private boolean copyReference(EReference eReference) {
        return this.copyChildren && eReference.isContainment() || this.copyReferences && !eReference.isContainment();
    }

    protected void copyFeatureMap(ModelObject<Object> source, ModelObject<Object> target, EStructuralFeature eFeature) {
        Collection targetCollection = (Collection)target.eGet(eFeature);
        for (Object sourceEntry : (Collection)source.eGet(eFeature)) {
            ModelFeatureMapEntry<?> sourceModelEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, sourceEntry);
            Object targetEntry = ModelResolver.getInstance().createFeatureMapEntry(eFeature);
            ModelFeatureMapEntry<?> targetModelEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, targetEntry);
            EStructuralFeature eFMFeature = sourceModelEntry.getEStructuralFeature();
            Object value = sourceModelEntry.getValue();
            if (eFMFeature instanceof EReference && this.copyReference((EReference)eFMFeature)) {
                value = this.copy(value);
            }
            targetModelEntry.setEStructuralFeature(eFMFeature);
            targetModelEntry.setValue(value);
            targetCollection.add(targetEntry);
        }
    }

    public void clear() {
        this.sourceTargetMap.clear();
    }

    public Collection<Object> getAllCopiedObjects() {
        return this.sourceTargetMap.values();
    }

    public Map<Object, Object> getSourceTargetMap() {
        return this.sourceTargetMap;
    }

    public void setSourceTargetMap(Map<Object, Object> sourceTargetMap) {
        this.sourceTargetMap = sourceTargetMap;
    }

    public boolean isCopyChildren() {
        return this.copyChildren;
    }

    public void setCopyChildren(boolean copyChildren) {
        this.copyChildren = copyChildren;
    }

    public boolean isCopyReferences() {
        return this.copyReferences;
    }

    public void setCopyReferences(boolean copyReferences) {
        this.copyReferences = copyReferences;
    }
}

