/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.store;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.store.EObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TexoResource
extends ResourceImpl
implements TexoComponent {
    public static final String TYPE_PARAMETER = "type";
    public static final String TYPES_PARAMETER = "types";
    private EObjectStore eObjectStore;
    private Set<EObject> modifiedObjects = new LinkedHashSet<EObject>();
    private Set<EObject> newObjects = new LinkedHashSet<EObject>();
    private Set<EObject> deletedObjects = new LinkedHashSet<EObject>();
    private boolean loaded = false;
    private boolean isSaving = false;
    private ObjectModificationTrackingAdapter objectModificationTrackingAdapter = this.createObjectModificationTrackingAdapter();

    public TexoResource() {
        this.setLoaded(true);
    }

    public TexoResource(URI uri) {
        super(uri);
        this.uriSet(uri);
        this.setLoaded(true);
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return true;
    }

    protected void attachedHelper(EObject eObject) {
        if (this.deletedObjects.contains(eObject)) {
            this.deletedObjects.remove(eObject);
        } else if (!this.isLoading() && !this.newObjects.contains(eObject)) {
            this.newObjects.add(eObject);
        }
        eObject.eAdapters().add((Object)this.objectModificationTrackingAdapter);
    }

    protected void detachedHelper(EObject eObject) {
        if (!(this.isSaving || this.isUnloading() || this.deletedObjects.contains(eObject))) {
            this.deletedObjects.add(eObject);
        }
        eObject.eAdapters().remove((Object)this.objectModificationTrackingAdapter);
        super.detachedHelper(eObject);
    }

    public boolean isUnloading() {
        return this.unloadingContents != null;
    }

    public void setURI(URI uri) {
        super.setURI(uri);
        this.uriSet(uri);
    }

    protected void uriSet(URI theUri) {
        this.getEObjectStore().setUri(theUri);
    }

    public String getURIFragment(EObject eObject) {
        return this.getEObjectStore().getQualifiedIdString(eObject);
    }

    public EObject getEObject(String uriFragment) {
        EObject eObject = this.getEObjectStore().getFromQualifiedIdString(uriFragment);
        if (eObject != null && eObject.eResource() == null) {
            this.addLoadedObject(eObject);
        }
        return eObject;
    }

    public synchronized void save(Map<?, ?> options) throws IOException {
        try {
            this.isSaving = true;
            ArrayList<EObject> toInsert = new ArrayList<EObject>();
            toInsert.addAll(this.newObjects);
            ArrayList<EObject> toUpdate = new ArrayList<EObject>();
            toUpdate.addAll(this.modifiedObjects);
            this.getEObjectStore().persist(toInsert, toUpdate, new ArrayList<EObject>(this.deletedObjects));
            this.newObjects.clear();
            this.modifiedObjects.clear();
            this.deletedObjects.clear();
        }
        finally {
            this.isSaving = false;
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        List<String> types = this.getTypes();
        for (String type : types) {
            this.query("select e from " + type + " e", Collections.<String, Object>emptyMap(), 0, -1);
        }
        this.loaded = true;
    }

    public boolean isLoaded() {
        if (this.loaded) {
            return true;
        }
        if (this.getTypes().isEmpty()) {
            return true;
        }
        return this.loaded;
    }

    protected void doUnload() {
        super.doUnload();
        this.newObjects.clear();
        this.modifiedObjects.clear();
        this.deletedObjects.clear();
        if (this.eObjectStore != null) {
            this.eObjectStore.clearCache();
        }
        this.loaded = false;
    }

    protected EObject getEObject(List<String> uriFragmentPath) {
        throw new UnsupportedOperationException();
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        throw new UnsupportedOperationException();
    }

    protected EObject getEObjectByID(String id) {
        return this.getEObject(id);
    }

    public void setIntrinsicIDToEObjectMap(Map<String, EObject> intrinsicIDToEObjectMap) {
        throw new UnsupportedOperationException();
    }

    public List<EObject> query(String qryStr, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        List<EObject> eObjects = this.getEObjectStore().query(qryStr, namedParameters, firstResult, maxResults);
        for (EObject eObject : eObjects) {
            if (eObject.eResource() != null) continue;
            this.addLoadedObject(eObject);
        }
        return eObjects;
    }

    protected void addLoadedObject(EObject eObject) {
        try {
            this.isLoading = true;
            if (eObject.eResource() == null) {
                if (eObject.eContainer() != null) {
                    this.addLoadedObject(eObject.eContainer());
                } else {
                    this.getContents().add((Object)eObject);
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    public void refresh(EObject eObject) {
        this.getEObjectStore().refresh(eObject);
    }

    public List<EObject> getReferingObjects(EObject target, int maxResult, boolean includeContainmentReferences) {
        List<EObject> eObjects = this.getEObjectStore().getReferingObjects(target, maxResult, includeContainmentReferences);
        for (EObject eObject : eObjects) {
            if (eObject.eResource() != null) continue;
            this.addLoadedObject(eObject);
        }
        return eObjects;
    }

    public synchronized EObjectStore getEObjectStore() {
        if (this.eObjectStore == null) {
            this.eObjectStore = this.createEObjectStore();
        }
        return this.eObjectStore;
    }

    protected EObjectStore createEObjectStore() {
        throw new UnsupportedOperationException("Override this method or set an object store");
    }

    public void setEObjectStore(EObjectStore eObjectStore) {
        this.eObjectStore = eObjectStore;
    }

    private List<String> getTypes() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.getURI() == null) {
            return values;
        }
        String queryString = this.getURI().query();
        if (queryString == null) {
            return values;
        }
        try {
            String[] stringArray = queryString.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] keyValue = param.split("=");
                String key = URLDecoder.decode(keyValue[0], "UTF-8");
                if ((TYPE_PARAMETER.equals(key) || TYPES_PARAMETER.equals(key)) && keyValue.length > 1) {
                    String value = URLDecoder.decode(keyValue[1], "UTF-8");
                    if (value.contains(",")) {
                        String[] stringArray2 = value.split(",");
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String val = stringArray2[n4];
                            values.add(val.trim());
                            ++n4;
                        }
                    } else {
                        values.add(value);
                    }
                    return values;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return values;
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceModificationTrackingAdapter();
    }

    protected ObjectModificationTrackingAdapter createObjectModificationTrackingAdapter() {
        return new ObjectModificationTrackingAdapter();
    }

    protected void unloaded(InternalEObject internalEObject) {
        super.unloaded(internalEObject);
        URI objectUri = this.getEObjectStore().toUri(internalEObject);
        this.getEObjectStore().removeFromCache(objectUri);
    }

    public void setChildLevels(int childLevels) {
        this.getEObjectStore().setChildLevels(childLevels);
    }

    public int getChildLevels() {
        return this.getEObjectStore().getChildLevels();
    }

    protected class ObjectModificationTrackingAdapter
    extends AdapterImpl {
        protected ObjectModificationTrackingAdapter() {
        }

        public void notifyChanged(Notification notification) {
            EObject notifier;
            if (TexoResource.this.isLoading() || TexoResource.this.isSaving || TexoResource.this.isUnloading()) {
                return;
            }
            if (!notification.isTouch() && notification.getNotifier() instanceof EObject && (notifier = (EObject)notification.getNotifier()).eResource() == TexoResource.this && !TexoResource.this.modifiedObjects.contains(notifier) && !TexoResource.this.newObjects.contains(notifier)) {
                TexoResource.this.modifiedObjects.add(notifier);
            }
        }
    }

    private class ResourceModificationTrackingAdapter
    extends ResourceImpl.ModificationTrackingAdapter {
        private ResourceModificationTrackingAdapter() {
            super((ResourceImpl)TexoResource.this);
        }

        public void notifyChanged(Notification notification) {
            if (TexoResource.this.isLoading() || TexoResource.this.isSaving || TexoResource.this.isUnloading()) {
                return;
            }
            super.notifyChanged(notification);
        }
    }
}

