/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.ui.plugins.internal.BaseCordovaPluginItem;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginCatalogViewer;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginWizardResources;

public class CordovaPluginInfoItem
extends BaseCordovaPluginItem<CordovaRegistryPluginInfo> {
    private static final String LABEL_TEXT_KEYWORDS = "keywords:";
    private static final String LABEL_TEXT_LATEST = "Latest: ";
    private static final int MAX_DESCRIPTION_CHARS = 162;
    private final CordovaPluginCatalogViewer viewer;
    private Button checkbox;
    private boolean installed;
    private Label nameLabel;
    private Label description;
    private String nameString;
    private String descriptionText;
    private Composite keywordsContainer;

    public CordovaPluginInfoItem(Composite parent, CordovaRegistryPluginInfo element, CordovaPluginWizardResources resources, CordovaPluginCatalogViewer viewer, boolean installed) {
        super(parent, element, resources);
        this.viewer = viewer;
        this.installed = installed;
    }

    @Override
    protected void refresh() {
        this.createContent();
        this.checkbox.setEnabled(!this.installed);
        this.nameLabel.setText(this.getNameString());
        this.description.setText(this.getDescriptionText());
        this.initKeywords();
    }

    private void initKeywords() {
        List keywords = ((CordovaRegistryPluginInfo)this.getData()).getKeywords();
        if (this.keywordsContainer == null && keywords != null) {
            int colSize = keywords == null ? 1 : keywords.size() + 1;
            this.keywordsContainer = new Composite((Composite)this, 0);
            GridDataFactory.swtDefaults().align(0x1000008, 1).span(3, 1).applyTo((Control)this.keywordsContainer);
            GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(colSize).applyTo(this.keywordsContainer);
            Label keywordLbl = new Label(this.keywordsContainer, 0);
            keywordLbl.setFont(this.resources.getSubTextFont());
            keywordLbl.setText(LABEL_TEXT_KEYWORDS);
            for (String string : keywords) {
                Link hyperlink = new Link(this.keywordsContainer, 0);
                hyperlink.setFont(this.resources.getSubTextFont());
                GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)hyperlink);
                hyperlink.setText(NLS.bind((String)"<a >{0}</a>", (Object)string));
                hyperlink.setData((Object)string);
                hyperlink.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Link link = (Link)event.widget;
                        String keyword = (String)link.getData();
                        CordovaPluginInfoItem.this.viewer.applyFilter(keyword);
                    }
                });
            }
        }
    }

    private String getDescriptionText() {
        if (this.descriptionText == null) {
            this.descriptionText = ((CordovaRegistryPluginInfo)this.getData()).getDescription();
            if (this.descriptionText == null) {
                this.descriptionText = "";
            }
            if (this.descriptionText.length() > 162) {
                this.descriptionText = this.descriptionText.substring(0, 162);
            }
            this.descriptionText = this.descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " ");
        }
        return this.descriptionText;
    }

    private String getNameString() {
        if (this.nameString != null) {
            return this.nameString;
        }
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this.checkbox.setSelection(false);
        } else {
            for (CordovaRegistryPluginInfo sel : selection) {
                if (sel != this.getData()) continue;
                this.checkbox.setSelection(true);
                break;
            }
        }
        this.nameString = this.installed ? NLS.bind((String)"{0} (installed)", (Object)((CordovaRegistryPluginInfo)this.getData()).getName()) : ((CordovaRegistryPluginInfo)this.getData()).getName();
        return this.nameString;
    }

    private void createContent() {
        if (this.nameLabel != null) {
            return;
        }
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        this.setLayout((Layout)layout);
        Composite checkboxContainer = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 3).applyTo((Control)checkboxContainer);
        GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(3).applyTo(checkboxContainer);
        this.checkbox = new Button(checkboxContainer, 34);
        this.checkbox.setText(" ");
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.checkbox);
        this.checkbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CordovaPluginInfoItem.this.viewer.modifySelection((CordovaRegistryPluginInfo)CordovaPluginInfoItem.this.getData(), CordovaPluginInfoItem.this.checkbox.getSelection());
            }
        });
        this.nameLabel = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.description = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 2).hint(100, -1).applyTo((Control)this.description);
        Label versionLbl = new Label((Composite)this, 0);
        versionLbl.setFont(this.resources.getSubTextFont());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)versionLbl);
        versionLbl.setText(LABEL_TEXT_LATEST + ((CordovaRegistryPluginInfo)this.getData()).getLatestVersion());
    }

    @Override
    public void updateColors(int index) {
        super.updateColors(index);
        if (this.installed) {
            this.setForeground(this.resources.getDisabledColor());
        } else {
            this.setForeground(this.getDisplay().getSystemColor(24));
        }
    }
}

