/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core.vstudio;

import java.io.File;
import org.eclipse.thym.core.platform.AbstractPluginInstallationActionsFactory;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.actions.CopyFileAction;
import org.eclipse.thym.core.plugin.actions.CreateFileAction;
import org.eclipse.thym.core.plugin.actions.JSModuleAction;
import org.eclipse.thym.core.plugin.actions.XMLConfigFileAction;
import org.eclipse.thym.wp.internal.core.Messages;
import org.eclipse.thym.wp.internal.core.vstudio.WPCopyFileAction;
import org.eclipse.thym.wp.internal.core.vstudio.WPProjectUtils;

public class WPPluginInstallationActionsFactory
extends AbstractPluginInstallationActionsFactory {
    private static final String PLUGINS = "Plugins";

    public IPluginInstallationAction getSourceFileAction(String src, String targetDir, String framework, String pluginId, String compilerFlags) {
        File source = new File(this.getPluginDirectory(), src);
        StringBuilder targetPath = this.calculateTargetPath(PLUGINS, targetDir, pluginId, source);
        File target = new File(this.getProjectDirectory(), targetPath.toString());
        return new WPCopyFileAction(source, target, this.getProjectDirectory());
    }

    public IPluginInstallationAction getResourceFileAction(String src, String target) {
        File source = new File(this.getPluginDirectory(), src);
        File targetDir = new File(this.getProjectDirectory(), target);
        return new WPCopyFileAction(source, targetDir, this.getProjectDirectory());
    }

    public IPluginInstallationAction getHeaderFileAction(String src, String targetDir, String pluginId) {
        throw new UnsupportedOperationException(Messages.WPPluginInstallationActionsFactory_NotImplementMessage);
    }

    public IPluginInstallationAction getAssetAction(String src, String target) {
        File source = new File(this.getPluginDirectory(), src);
        File targetDir = new File(WPProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), target);
        return new CopyFileAction(source, targetDir);
    }

    public IPluginInstallationAction getConfigFileAction(String target, String parent, String value) {
        File targetFile = new File(this.getProjectDirectory(), target);
        return new XMLConfigFileAction(targetFile, parent, value);
    }

    public IPluginInstallationAction getLibFileAction(String src, String arch) {
        throw new UnsupportedOperationException(Messages.WPPluginInstallationActionsFactory_NotImplementMessage);
    }

    public IPluginInstallationAction getFrameworkAction(String src, String weak, String pluginId, String custom, String type, String parent) {
        throw new UnsupportedOperationException(Messages.WPPluginInstallationActionsFactory_NotImplementMessage);
    }

    public IPluginInstallationAction getJSModuleAction(String src, String pluginId, String jsModuleName) {
        File sourceFile = new File(this.getPluginDirectory(), src);
        File targetFile = new File(WPProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), "plugins" + File.separator + pluginId + File.separator + src);
        return new JSModuleAction(sourceFile, targetFile, jsModuleName);
    }

    public IPluginInstallationAction getCreatePluginJSAction(String content) {
        File pluginJs = new File(WPProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), "cordova_plugins.js");
        return new CreateFileAction(content, pluginJs);
    }

    private StringBuilder calculateTargetPath(String groupDir, String targetDir, String pluginId, File source) {
        StringBuilder targetPath = new StringBuilder();
        if (groupDir != null) {
            targetPath.append(groupDir).append(File.separator);
        }
        if (pluginId != null) {
            targetPath.append(pluginId).append(File.separator);
        }
        if (targetDir != null) {
            targetPath.append(targetDir).append(File.separator);
        }
        targetPath.append(source.getName());
        return targetPath;
    }
}

