/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.RestorableCordovaPlugin;
import org.eclipse.thym.ui.internal.status.StatusManager;

public class PluginRestorePage
extends WizardPage {
    private static final int TABLE_HEIGHT = 250;
    private static final int TABLE_WIDTH = 350;
    private CheckboxTableViewer restorableList;
    private HybridProject project;

    protected PluginRestorePage(HybridProject project) {
        super("Restore Plugins");
        this.setTitle("Restore Cordova plug-ins");
        this.setDescription("Select config.xml referenced Cordova plug-ins to be restored");
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Label tableLbl = new Label(composite, 0);
        tableLbl.setText("Discovered the following Cordova plug-ins on config.xml and will attempt to restore the selected plug-in(s)");
        GridDataFactory.generate((Control)tableLbl, (int)2, (int)1);
        Table table = new Table(composite, 67620);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(new Point(350, 250)).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn col = new TableColumn(table, 0);
        col.setWidth(175);
        col.setText("ID");
        col = new TableColumn(table, 0);
        col.setText("Version");
        col.setWidth(this.getMinColumnWidth((Control)table, "Version"));
        col = new TableColumn(table, 0);
        col.setText("Source");
        col.setWidth(this.getMinColumnWidth((Control)table, "registry"));
        col = new TableColumn(table, 0);
        col.setText("Info");
        col.setWidth(175);
        this.restorableList = new CheckboxTableViewer(table);
        this.restorableList.setContentProvider((IContentProvider)new RestorablePluginsContentProvider());
        this.restorableList.setLabelProvider((IBaseLabelProvider)new RestorablePluginLabelProvider());
        this.setControl((Control)composite);
    }

    private int getMinColumnWidth(Control control, String label) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        return gc.stringExtent((String)label).x + 10;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PluginRestorePage.this.populateRestorables();
            }
        });
    }

    private void populateRestorables() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final List restorables = PluginRestorePage.this.project.getPluginManager().getRestorablePlugins(monitor);
                        PluginRestorePage.this.getControl().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BusyIndicator.showWhile((Display)PluginRestorePage.this.getControl().getDisplay(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        PluginRestorePage.this.restorableList.setInput((Object)restorables);
                                        PluginRestorePage.this.restorableList.setAllChecked(true);
                                    }
                                });
                            }
                        });
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Restorable Cordova Plug-ins error", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error while generating the list of restorable Cordova plug-ins", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    public RestorableCordovaPlugin[] getSelectedRestorables() {
        Object[] checked = this.restorableList.getCheckedElements();
        return (RestorableCordovaPlugin[])Arrays.copyOf(checked, checked.length, RestorableCordovaPlugin[].class);
    }

    private class RestorablePluginLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RestorablePluginLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            RestorableCordovaPlugin rp = (RestorableCordovaPlugin)element;
            String typeLbl = null;
            String infoLbl = "-";
            switch (rp.getType()) {
                case LOCAL: {
                    typeLbl = "local";
                    infoLbl = rp.getPath();
                    break;
                }
                case REGISTRY: {
                    typeLbl = "registry";
                    break;
                }
                case GIT: {
                    typeLbl = "git";
                    infoLbl = rp.getUrl();
                }
            }
            switch (columnIndex) {
                case 0: {
                    return rp.getId();
                }
                case 1: {
                    String ver = rp.getVersion();
                    if (ver == null || ver.isEmpty()) {
                        return "-";
                    }
                    return ver;
                }
                case 2: {
                    return typeLbl;
                }
                case 3: {
                    return infoLbl;
                }
            }
            return "";
        }
    }

    private class RestorablePluginsContentProvider
    implements IStructuredContentProvider {
        private RestorableCordovaPlugin[] restorables;

        private RestorablePluginsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.restorables = null;
            } else {
                List restorableList = (List)newInput;
                this.restorables = restorableList.toArray(new RestorableCordovaPlugin[restorableList.size()]);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.restorables;
        }
    }
}

