/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.ConfigJSon;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.osgi.framework.Bundle;

public class HybridProjectCreator {
    private static final String[] COMMON_PATHS = new String[]{".cordova", "merges", "plugins", "www"};

    public IProject createBasicTemplatedProject(String projectName, URI location, String appName, String appID, HybridMobileEngine engine, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject project = this.createProject(projectName, location, appName, appID, engine, monitor);
        this.addTemplateFiles(project, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        project.refreshLocal(2, monitor);
        this.updateConfig(project, appName, appID, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.refreshLocal(2, monitor);
        return project;
    }

    public IProject createProject(String projectName, URI location, String appName, String appID, HybridMobileEngine engine, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject project = this.createHybridMobileProject(projectName, location, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.addCommonPaths(project, monitor);
        this.addPlatformPaths(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.addConfigJSon(project, appName, appID, engine, monitor);
        this.setUpJavaScriptProject(monitor, project);
        return project;
    }

    private IProject createHybridMobileProject(String projectName, URI location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)projectName, (String)"Project name is null, can not create a project without a name");
        IProject project = this.createBasicProject(projectName, location, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        this.addNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        return project;
    }

    private void setUpJavaScriptProject(IProgressMonitor monitor, IProject project) throws JavaScriptModelException {
        IJavaScriptProject javascriptProject = JavaScriptCore.create((IProject)project);
        IIncludePathEntry[] entries = javascriptProject.getRawIncludepath();
        ArrayList<IIncludePathEntry> entryList = new ArrayList<IIncludePathEntry>(Arrays.asList(entries));
        IIncludePathEntry cordovaLibEntry = JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.thym.core.CordovaContainerInitializer"));
        entryList.add(cordovaLibEntry);
        for (IIncludePathEntry aEntry : entryList) {
            if (3 != aEntry.getEntryKind()) continue;
            entryList.remove(aEntry);
        }
        IIncludePathEntry wwwSrcEntry = JavaScriptCore.newSourceEntry((IPath)project.getFolder("www").getFullPath());
        entryList.add(wwwSrcEntry);
        javascriptProject.setRawIncludepath(entryList.toArray(new IIncludePathEntry[entryList.size()]), monitor);
    }

    private void updateConfig(IProject project, String appName, String appID, IProgressMonitor monitor) throws CoreException {
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)project);
        try {
            WidgetModel model = WidgetModel.getModel((HybridProject)hybridProject);
            Widget w = model.getWidgetForEdit();
            w.setId(appID);
            w.setName(appName);
            model.save();
        }
        catch (CoreException e) {
            HybridCore.log((int)4, (String)"Error updating application name and id to config.xml", (Throwable)e);
        }
    }

    private void addTemplateFiles(IProject project, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = HybridUI.getDefault().getBundle();
        URL source = bundle.getEntry("/templates/www");
        IFolder folder = project.getFolder("www");
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        try {
            FileUtils.directoryCopy((URL)source, (URL)FileUtils.toURL((File)folder.getLocation().toFile()));
            monitor.done();
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", "Error adding template files", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", "Error adding template files", (Throwable)e));
        }
    }

    private void addConfigJSon(IProject project, String applicationName, String applicationID, HybridMobileEngine engine, IProgressMonitor monitor) throws CoreException {
        ConfigJSon configJson = new ConfigJSon();
        configJson.setId(applicationID);
        configJson.setName(applicationName);
        configJson.setEngineInfo(engine);
        configJson.persist(project);
    }

    private void addPlatformPaths(IProject project, IProgressMonitor monitor) throws CoreException {
        List platforms = HybridCore.getPlatformSupports();
        Path merges = new Path("merges");
        for (PlatformSupport platform : platforms) {
            IFolder folder = project.getFolder(merges.append(platform.getPlatformId()));
            if (folder.exists()) continue;
            this.createFolder(folder, monitor);
        }
        monitor.done();
    }

    private void addCommonPaths(IProject project, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, COMMON_PATHS.length);
        String[] stringArray = COMMON_PATHS;
        int n = COMMON_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IFolder folder = project.getFolder(path);
            if (!folder.exists()) {
                this.createFolder(folder, (IProgressMonitor)subMonitor);
            }
            subMonitor.worked(1);
            ++n2;
        }
        subMonitor.done();
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer parent = folder.getParent();
        IFolder parentFolder = (IFolder)parent.getAdapter(IFolder.class);
        if (parentFolder != null) {
            this.createFolder(parentFolder, monitor);
        }
        if (!folder.exists()) {
            folder.create(false, true, monitor);
        }
    }

    private void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] oldNatures = description.getNatureIds();
        ArrayList<String> natureList = new ArrayList<String>();
        natureList.addAll(Arrays.asList(oldNatures));
        if (!project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
            natureList.add("org.eclipse.thym.core.HybridAppNature");
        }
        if (!project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            natureList.add("org.eclipse.wst.jsdt.core.jsNature");
        }
        description.setNatureIds(natureList.toArray(new String[natureList.size()]));
        project.setDescription(description, monitor);
    }

    private IProject createBasicProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject newProject = workspaceRoot.getProject(name);
        if (!newProject.exists()) {
            IProjectDescription description = newProject.getWorkspace().newProjectDescription(name);
            if (location != null) {
                description.setLocationURI(location);
            }
            newProject.create(description, monitor);
            if (!newProject.isOpen()) {
                newProject.open(monitor);
            }
        }
        return newProject;
    }
}

