/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineManager;
import org.eclipse.thym.core.plugin.CordovaPluginManager;

public class HybridProject
implements IAdaptable {
    private static final IPath[] CONFIG_PATHS = new IPath[]{new Path("www").append("config.xml"), new Path("config.xml")};
    private IProject kernelProject;
    private CordovaPluginManager pluginManager;
    private HybridMobileEngineManager engineManager;

    private HybridProject(IProject project) {
        this.kernelProject = project;
    }

    public IProject getProject() {
        return this.kernelProject;
    }

    public static HybridProject getHybridProject(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            if (project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
                return new HybridProject(project);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static HybridProject getHybridProject(String projectName) {
        if (projectName == null || projectName.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        return HybridProject.getHybridProject(project);
    }

    public CordovaPluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = new CordovaPluginManager(this);
        }
        return this.pluginManager;
    }

    public String getAppName() {
        String name = null;
        try {
            WidgetModel widgetModel = WidgetModel.getModel(this);
            Widget w = widgetModel.getWidgetForRead();
            if (w != null) {
                name = w.getName();
            }
        }
        catch (CoreException coreException) {}
        if (name == null || name.isEmpty()) {
            name = this.kernelProject.getName();
        }
        return name;
    }

    public String getBuildArtifactAppName() {
        String name = this.getAppName();
        name = name.replaceAll("\\W", "_");
        return name;
    }

    public IFile getConfigFile() {
        IPath[] iPathArray = CONFIG_PATHS;
        int n = CONFIG_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            IPath configPath = iPathArray[n2];
            IFile f = this.kernelProject.getFile(configPath);
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    private HybridMobileEngineManager getHybridMobileEngineManager() {
        if (this.engineManager == null) {
            this.engineManager = new HybridMobileEngineManager(this);
        }
        return this.engineManager;
    }

    public HybridMobileEngine getActiveEngine() {
        return this.getHybridMobileEngineManager().getActiveEngine();
    }

    public void updateActiveEngine(HybridMobileEngine engine) throws CoreException {
        Assert.isLegal((engine != null ? 1 : 0) != 0, (String)"Engine can not be null");
        this.getHybridMobileEngineManager().updateEngine(engine);
    }

    public boolean equals(Object obj) {
        if (this.kernelProject == null) {
            return super.equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridProject)) {
            return false;
        }
        IProject prj = ((HybridProject)obj).getProject();
        return this.kernelProject.equals((Object)prj);
    }

    public int hashCode() {
        if (this.kernelProject == null) {
            return super.hashCode();
        }
        return this.kernelProject.hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (this.kernelProject == null) {
            return null;
        }
        if (adapter.isInstance(IProject.class)) {
            return this.kernelProject;
        }
        return this.kernelProject.getAdapter(adapter);
    }
}

