/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class HybridProjectConventions {
    public static IStatus validateProjectName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return new Status(4, "org.eclipse.thym.core", "Project name must be specified");
        }
        Pattern pattern = Pattern.compile("[_a-zA-z][_a-zA-Z0-9]*");
        if (!pattern.matcher(name).matches()) {
            return new Status(4, "org.eclipse.thym.core", NLS.bind((String)"{0} is not a valid application name", (Object)name));
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateProjectID(String id) {
        if (id == null || id.trim().isEmpty()) {
            return new Status(4, "org.eclipse.thym.core", "Application ID must be specified");
        }
        Pattern pattern = Pattern.compile("([a-zA-Z][a-zA-Z\\d_]*[\\.])+[a-zA-Z_][a-zA-Z\\d_]*");
        if (!pattern.matcher(id).matches()) {
            return new Status(4, "org.eclipse.thym.core", NLS.bind((String)"{0} is not a valid application id", (Object)id));
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateApplicationName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return new Status(4, "org.eclipse.thym.core", "Application name must be specified");
        }
        if (name.length() >= 25) {
            return new Status(2, "org.eclipse.thym.core", "Application names are recommended to have fewer than 25 characters for best presentation.");
        }
        return Status.OK_STATUS;
    }

    public static String generateProjectID(String projectName) {
        if (projectName == null || projectName.isEmpty()) {
            return "";
        }
        List<String> tokens = HybridProjectConventions.tokenizeProjectName(projectName);
        if (tokens.size() < 2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : tokens) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(string.toLowerCase());
        }
        return sb.toString();
    }

    public static String generateApplicationName(String projectName) {
        if (projectName == null || projectName.isEmpty()) {
            return "";
        }
        List<String> tokens = HybridProjectConventions.tokenizeProjectName(projectName);
        StringBuilder sb = new StringBuilder();
        for (String string : tokens) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(string);
        }
        return sb.toString();
    }

    private static List<String> tokenizeProjectName(String projectName) {
        char[] c = projectName.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        int pos = tokenStart + 1;
        while (pos < c.length) {
            int type = Character.getType(c[pos]);
            if ((type != currentType || c[pos] == '_') && type != 9) {
                if (type == 2 && currentType == 1) {
                    int newTokenStart = pos - 1;
                    if (newTokenStart != tokenStart) {
                        list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                        tokenStart = newTokenStart;
                    }
                } else {
                    list.add(new String(c, tokenStart, pos - tokenStart));
                    if (!Character.isJavaIdentifierStart(c[pos]) && !Character.isJavaIdentifierPart(c[pos]) || c[pos] == '_') {
                        tokenStart = Math.min(pos + 1, c.length - 1);
                        type = Character.getType(c[tokenStart]);
                    } else {
                        tokenStart = pos;
                    }
                }
                currentType = type;
            }
            ++pos;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list;
    }
}

