/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.AbstractEngineRepoProvider;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineLocator;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.PlatformLibrary;
import org.eclipse.thym.core.engine.internal.cordova.DefaultEngineRepoProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.engine.internal.cordova.EngineDownloadReceiver;
import org.eclipse.thym.core.extensions.CordovaEngineRepoProvider;
import org.eclipse.thym.core.extensions.PlatformSupport;

public class CordovaEngineProvider
implements HybridMobileEngineLocator,
HybridMobileEngineLocator.EngineSearchListener {
    private static final Version MIN_VERSION = Version.forIntegers((int)3, (int)0, (int)0);
    public static final String CORDOVA_ENGINE_ID = "cordova";
    public static final String ENGINE_NAME = "Apache Cordova";
    public static final String CUSTOM_CORDOVA_ENGINE_ID = "custom_cordova";
    private static ArrayList<HybridMobileEngine> engineList;

    public List<HybridMobileEngine> getAvailableEngines() {
        this.initEngineList();
        return engineList;
    }

    private void resetEngineList() {
        engineList = null;
    }

    private void initEngineList() {
        if (engineList != null) {
            return;
        }
        engineList = new ArrayList();
        File libFolder = CordovaEngineProvider.getLibFolder().toFile();
        if (!libFolder.isDirectory()) {
            return;
        }
        this.searchForRuntimes((IPath)new Path(libFolder.toString()), this, (IProgressMonitor)new NullProgressMonitor());
        String[] locs = HybridCore.getDefault().getCustomLibraryLocations();
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                this.searchForRuntimes((IPath)new Path(locs[i]), this, (IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    public String getName() {
        return ENGINE_NAME;
    }

    public HybridMobileEngine getEngine(String id, String version) {
        this.initEngineList();
        for (HybridMobileEngine engine : engineList) {
            if (!engine.getVersion().equals(version) || !engine.getId().equals(id)) continue;
            return engine;
        }
        return null;
    }

    public HybridMobileEngine createEngine(String id, String version, PlatformLibrary ... platforms) {
        HybridMobileEngine engine = new HybridMobileEngine();
        engine.setId(id);
        engine.setName(ENGINE_NAME);
        engine.setVersion(version);
        int i = 0;
        while (i < platforms.length) {
            engine.addPlatformLib(platforms[i]);
            ++i;
        }
        return engine;
    }

    public static IPath getLibFolder() {
        Path path = new Path(FileUtils.getUserDirectory().toString());
        path = path.append(".cordova").append("lib");
        return path;
    }

    public List<DownloadableCordovaEngine> getDownloadableVersions() throws CoreException {
        AbstractEngineRepoProvider provider = new DefaultEngineRepoProvider();
        IProduct product = Platform.getProduct();
        if (product != null) {
            String productId = Platform.getProduct().getId();
            List<CordovaEngineRepoProvider> providerProxies = HybridCore.getCordovaEngineRepoProviders();
            for (CordovaEngineRepoProvider providerProxy : providerProxies) {
                if (!productId.equals(providerProxy.getProductId())) continue;
                provider = providerProxy.createProvider();
            }
        }
        return ((AbstractEngineRepoProvider)provider).getEngines();
    }

    private DownloadableCordovaEngine getDownloadableCordovaEngine(String version) {
        try {
            List<DownloadableCordovaEngine> versions = this.getDownloadableVersions();
            for (DownloadableCordovaEngine downloadableCordovaEngine : versions) {
                if (!version.equals(downloadableCordovaEngine.getVersion())) continue;
                return downloadableCordovaEngine;
            }
        }
        catch (CoreException e) {
            HybridCore.log(4, "Could not retrieve downloadable engine list", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadEngine(String version, IProgressMonitor monitor, String ... platforms) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        DownloadableCordovaEngine theEngine = this.getDownloadableCordovaEngine(version);
        IRetrieveFileTransfer transfer = HybridCore.getDefault().getFileTransferService();
        int platformSize = platforms.length;
        Object lock = new Object();
        int incompleteCount = platformSize;
        monitor.beginTask("Download Cordova Engine " + version, platformSize * 100 + 1);
        monitor.worked(1);
        int i = 0;
        while (i < platformSize) {
            DownloadableCordovaEngine.LibraryDownloadInfo downloadInfo = theEngine.getPlatformLibraryInfo(platforms[i]);
            Assert.isNotNull((Object)downloadInfo);
            try {
                URI uri = URI.create(downloadInfo.getDownloadURL());
                IFileID remoteFileID = FileIDFactory.getDefault().createFileID(transfer.getRetrieveNamespace(), uri);
                SubProgressMonitor sm = new SubProgressMonitor(monitor, 100);
                if (monitor.isCanceled()) {
                    return;
                }
                transfer.sendRetrieveRequest(remoteFileID, (IFileTransferListener)new EngineDownloadReceiver(downloadInfo.getVersion(), platforms[i], lock, (IProgressMonitor)sm), null);
            }
            catch (FileCreateException e) {
                HybridCore.log(4, "Engine download file create error", e);
            }
            catch (IncomingFileTransferException e) {
                HybridCore.log(4, "Engine download file transfer error", e);
            }
            ++i;
        }
        Object object = lock;
        synchronized (object) {
            while (incompleteCount > 0) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    HybridCore.log(1, "interrupted while waiting for all engines to download", e);
                }
                --incompleteCount;
            }
        }
        monitor.done();
        this.resetEngineList();
    }

    public boolean isSupportedPlatform(String version, String platformId) {
        Assert.isNotNull((Object)platformId);
        Assert.isNotNull((Object)version);
        DownloadableCordovaEngine engine = this.getDownloadableCordovaEngine(version);
        if (engine == null) {
            return false;
        }
        DownloadableCordovaEngine.LibraryDownloadInfo lib = engine.getPlatformLibraryInfo(platformId);
        return lib != null;
    }

    @Override
    public void searchForRuntimes(IPath path, HybridMobileEngineLocator.EngineSearchListener listener, IProgressMonitor monitor) {
        if (path == null) {
            return;
        }
        File root = path.toFile();
        if (!root.isDirectory()) {
            return;
        }
        this.searchDir(root, listener, monitor);
    }

    private void searchDir(File dir, HybridMobileEngineLocator.EngineSearchListener listener, IProgressMonitor monitor) {
        File[] dirs;
        File createScript;
        if ("bin".equals(dir.getName()) && (createScript = new File(dir, "create")).exists()) {
            Path libraryRoot = new Path(dir.getParent());
            List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
            for (PlatformSupport platformSupport : platforms) {
                try {
                    HybridMobileLibraryResolver resolver = platformSupport.getLibraryResolver();
                    resolver.init((IPath)libraryRoot);
                    if (!resolver.isLibraryConsistent().isOK()) continue;
                    PlatformLibrary lib = new PlatformLibrary(platformSupport.getPlatformId(), (IPath)libraryRoot);
                    listener.libraryFound(lib);
                    return;
                }
                catch (CoreException e) {
                    HybridCore.log(2, "Error on engine search", e);
                }
            }
        }
        if ((dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            int i = 0;
            while (i < dirs.length) {
                if (!monitor.isCanceled()) {
                    this.searchDir(dirs[i], listener, monitor);
                }
                ++i;
            }
        }
    }

    @Override
    public void libraryFound(PlatformLibrary library) {
        String version = this.getEngineVersion(library);
        if (version == null) {
            return;
        }
        boolean isDefaultLoc = CordovaEngineProvider.getLibFolder().isPrefixOf(library.getLocation());
        String id = isDefaultLoc ? CORDOVA_ENGINE_ID : CUSTOM_CORDOVA_ENGINE_ID;
        Version v = Version.valueOf((String)version);
        if (v.greaterThanOrEqualTo(MIN_VERSION)) {
            HybridMobileEngine engine = this.getEngine(id, version);
            if (engine == null) {
                engineList.add(this.createEngine(id, version, library));
            } else {
                engine.addPlatformLib(library);
            }
        }
    }

    private String getEngineVersion(PlatformLibrary library) {
        String libVersion = library.getPlatformLibraryResolver().detectVersion();
        try {
            List<DownloadableCordovaEngine> engines = this.getDownloadableVersions();
            for (DownloadableCordovaEngine cordovaEngine : engines) {
                DownloadableCordovaEngine.LibraryDownloadInfo platformLibraryInfo = cordovaEngine.getPlatformLibraryInfo(library.getPlatformId());
                if (platformLibraryInfo == null || !platformLibraryInfo.getVersion().equals(libVersion)) continue;
                return cordovaEngine.getVersion();
            }
        }
        catch (CoreException e) {
            HybridCore.log(2, "Could not read downloadable engines", e);
        }
        return libVersion;
    }

    public void deleteEngineLibraries(HybridMobileEngine selectedEngine) {
        if (selectedEngine.getId().equals(CORDOVA_ENGINE_ID)) {
            List<PlatformLibrary> libs = selectedEngine.getPlatformLibs();
            if (libs.isEmpty()) {
                return;
            }
            for (PlatformLibrary library : libs) {
                IPath path = library.getLocation();
                FileUtils.deleteQuietly((File)path.toFile());
            }
        }
        this.resetEngineList();
    }
}

