/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.internal.util.XMLUtil;
import org.eclipse.thym.core.plugin.actions.XMLConfigFileAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigXMLUpdateAction
extends XMLConfigFileAction {
    private final HybridProject project;

    public ConfigXMLUpdateAction(HybridProject project, String parent, String value) {
        super(project.getConfigFile().getLocation().toFile(), parent, value);
        this.project = project;
    }

    @Override
    public void install() throws CoreException {
        Element featureNode = this.getInjectedFeatureNode();
        WidgetModel widgetModel = WidgetModel.getModel(this.project);
        if (featureNode == null) {
            super.install();
            widgetModel.resyncModel();
        } else {
            Widget widget = widgetModel.getWidgetForEdit();
            Feature feature = this.getExistingFeature(featureNode, widget);
            if (feature == null) {
                feature = widgetModel.createFeature(widget);
                feature.setName(featureNode.getAttribute("name"));
                String required = featureNode.getAttribute("required");
                boolean isRequired = Boolean.parseBoolean(required);
                if (isRequired) {
                    feature.setRequired(isRequired);
                }
                widget.addFeature(feature);
            }
            NodeList nodes = featureNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node currNode = nodes.item(i);
                if (currNode.getNodeName().equals("param")) {
                    Element el = (Element)currNode;
                    feature.addParam(el.getAttribute("name"), el.getAttribute("value"));
                }
                ++i;
            }
            widgetModel.save();
        }
    }

    private Element getInjectedFeatureNode() throws CoreException {
        Document doc = XMLUtil.loadXML(this.xml);
        Element element = doc.getDocumentElement();
        NodeList featureNodes = element.getElementsByTagName("feature");
        Element featureNode = null;
        if (featureNodes.getLength() == 1) {
            featureNode = (Element)featureNodes.item(0);
        }
        return featureNode;
    }

    private Feature getExistingFeature(Element element, Widget widget) {
        String featureName = element.getAttribute("name");
        List<Feature> features = widget.getFeatures();
        if (features == null) {
            return null;
        }
        for (Feature feature : features) {
            if (!feature.getName().equals(featureName)) continue;
            return feature;
        }
        return null;
    }

    @Override
    public void unInstall() throws CoreException {
        Element featureNode = this.getInjectedFeatureNode();
        if (featureNode == null) {
            super.install();
        } else {
            WidgetModel widgetModel = WidgetModel.getModel(this.project);
            Widget widget = widgetModel.getWidgetForEdit();
            Feature feature = this.getExistingFeature(featureNode, widget);
            if (feature != null) {
                widget.removeFeature(feature);
            }
            widgetModel.save();
        }
    }
}

