/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.android.core.adt.AndroidSDK;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.core.platform.IPluginInstallationAction;

public class AndroidFrameworkAction
implements IPluginInstallationAction {
    private final IPath source;
    private final File projectDir;
    private final File pluginDir;
    private final boolean isCustom;
    private final String parent;
    private final String pluginId;
    private final AndroidSDK sdk;

    public AndroidFrameworkAction(String src, String custom, String parent, String pluginId, File projectDir, File pluginDir, AndroidSDK sdk) {
        this.source = new Path(src);
        this.parent = parent;
        this.projectDir = projectDir;
        this.pluginDir = pluginDir;
        this.pluginId = pluginId;
        this.sdk = sdk;
        this.isCustom = custom == null ? false : Boolean.parseBoolean(custom);
    }

    public String[] filesToOverwrite() {
        return null;
    }

    public void install() throws CoreException {
        String libref = "";
        if (this.isCustom) {
            IPath dest = new Path(this.projectDir.toString()).append(this.getFrameworkSubDir());
            try {
                File destFile = new File(dest.toString());
                FileUtils.copyDirectory((File)new File(this.pluginDir, this.source.toString()), (File)destFile);
                AndroidSDKManager.getManager().updateProject(this.sdk, null, true, destFile, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Copying custom framework failed", (Throwable)e));
            }
            libref = this.getFrameworkSubDir().toString();
        } else {
            File sdkDir = new File(AndroidCore.getSDKLocation());
            File subSDK = new File(sdkDir, this.source.toString());
            libref = subSDK.toString();
        }
        try {
            File propertiesFile = this.getPropertiesFile();
            Properties properties = new Properties();
            properties.load(new FileReader(propertiesFile));
            int index = 1;
            String keyName = "android.library.reference." + Integer.toString(index);
            while (properties.containsKey(keyName)) {
                keyName = "android.library.reference." + Integer.toString(++index);
            }
            properties.put(keyName, libref);
            properties.store(new FileWriter(propertiesFile), "Updated by Eclipse THyM");
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Updating the project.properties file has failed", (Throwable)e));
        }
    }

    public void unInstall() throws CoreException {
        String libref = "";
        if (this.isCustom) {
            IPath dest = new Path(this.projectDir.toString()).append(this.getFrameworkSubDir());
            File destFile = new File(dest.toString());
            FileUtils.deleteQuietly((File)destFile);
            libref = this.getFrameworkSubDir().toString();
        } else {
            File sdkDir = new File(AndroidCore.getSDKLocation());
            File subSDK = new File(sdkDir, this.source.toString());
            libref = subSDK.toString();
        }
        try {
            File propertiesFile = this.getPropertiesFile();
            Properties properties = new Properties();
            properties.load(new FileReader(propertiesFile));
            int index = 1;
            String keyName = "android.library.reference." + Integer.toString(index);
            while (properties.containsKey(keyName)) {
                String val = properties.getProperty(keyName);
                if (val.equals(libref)) {
                    properties.remove(keyName);
                    break;
                }
                keyName = "android.library.reference." + Integer.toString(++index);
            }
            properties.store(new FileWriter(propertiesFile), "Updated by Eclipse THyM");
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Updating the project.properties file has failed", (Throwable)e));
        }
    }

    private File getPropertiesFile() {
        File propertiesFile = this.parent == null || this.parent.equals(".") ? new File(this.projectDir, "project.properties") : new File(this.projectDir, String.valueOf(this.pluginId) + File.separator + this.parent + File.separator + "project.properties");
        return propertiesFile;
    }

    private IPath getFrameworkSubDir() {
        Path subdir = new Path(this.pluginId);
        if (this.parent != null) {
            subdir = subdir.append(this.parent);
        }
        return subdir.append(this.source.lastSegment());
    }
}

