/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.AbstractConfigObject;
import org.eclipse.thym.core.config.Access;
import org.eclipse.thym.core.config.Author;
import org.eclipse.thym.core.config.Content;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Icon;
import org.eclipse.thym.core.config.License;
import org.eclipse.thym.core.config.Preference;
import org.eclipse.thym.core.config.Splash;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WidgetModel
implements IModelLifecycleListener {
    private static Map<HybridProject, WidgetModel> widgetModels = new HashMap<HybridProject, WidgetModel>();
    public static final String[] ICON_EXTENSIONS = new String[]{"gif", "ico", "jpeg", "jpg", "png", "svg"};
    private File configFile;
    private Widget editableWidget;
    private Widget readonlyWidget;
    private long readonlyTimestamp;
    public IStructuredModel underLyingModel;

    private WidgetModel(HybridProject project) {
        this(WidgetModel.getConfigXml(project));
    }

    private WidgetModel(File file) {
        this.configFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final WidgetModel getModel(HybridProject project) {
        if (project == null) {
            throw new NullPointerException("Widget model can not be created because hybrid project is null");
        }
        if (widgetModels.containsKey(project)) return widgetModels.get(project);
        Class<WidgetModel> clazz = WidgetModel.class;
        synchronized (WidgetModel.class) {
            WidgetModel wm = new WidgetModel(project);
            widgetModels.put(project, wm);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return widgetModels.get(project);
        }
    }

    public static final Widget parseToWidget(File file) throws CoreException {
        if (file.isFile()) {
            WidgetModel model = new WidgetModel(file);
            return model.getWidgetForRead();
        }
        throw new IllegalArgumentException(NLS.bind((String)"File {0} does not exist ", (Object)file.toString()));
    }

    public static final void shutdown() {
        Collection<WidgetModel> createdModels = widgetModels.values();
        for (WidgetModel widgetModel : createdModels) {
            widgetModel.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Widget getWidgetForRead() throws CoreException {
        long enter = System.currentTimeMillis();
        if (!this.configFile.exists()) {
            return null;
        }
        if (this.readonlyWidget == null || this.readonlyTimestamp != this.configFile.lastModified()) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document configDocument = db.parse(this.configFile);
                    this.readonlyWidget = this.load(configDocument);
                    this.readonlyTimestamp = this.configFile.lastModified();
                }
                catch (ParserConfigurationException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser error when parsing config.xml", (Throwable)e));
                }
                catch (SAXException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Failed to parse config.xml", (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "IO error when parsing config.xml", (Throwable)e));
                }
            }
        }
        HybridCore.trace("Completed WidgetModel.getWidgetForRead it " + Long.toString(System.currentTimeMillis() - enter) + "ms");
        return this.readonlyWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Widget getWidgetForEdit() throws CoreException {
        long enter = System.currentTimeMillis();
        if (this.editableWidget == null) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                IFile configXml;
                block8: {
                    configXml = this.configXMLtoIFile();
                    if (configXml != null) break block8;
                    return null;
                }
                IModelManager manager = StructuredModelManager.getModelManager();
                try {
                    this.underLyingModel = manager.getModelForEdit(configXml);
                    if (this.underLyingModel != null && this.underLyingModel instanceof IDOMModel) {
                        this.underLyingModel.addModelLifecycleListener((IModelLifecycleListener)this);
                        IDOMModel domModel = (IDOMModel)this.underLyingModel;
                        this.editableWidget = this.load((Document)domModel.getDocument());
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error creating widget model", (Throwable)e));
                }
            }
        }
        HybridCore.trace("Completed WidgetModel.getWidgetForEdit it " + Long.toString(System.currentTimeMillis() - enter) + "ms");
        return this.editableWidget;
    }

    protected IFile configXMLtoIFile() {
        IFile[] configFileCandidates = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(this.configFile.toURI());
        if (configFileCandidates == null || configFileCandidates.length == 0) {
            return null;
        }
        return configFileCandidates[0];
    }

    public void resyncModel() throws CoreException {
        if (this.underLyingModel != null) {
            try {
                IFile configXml = this.configXMLtoIFile();
                if (configXml != null) {
                    configXml.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    this.underLyingModel.getModelHandler().getModelLoader().load(configXml, this.underLyingModel);
                }
            }
            catch (IOException e) {
                HybridCore.log(4, "Error resyncing the editable model", e);
            }
        }
    }

    private static File getConfigXml(HybridProject project) {
        IFile configXml = project.getConfigFile();
        return configXml.getLocation().toFile();
    }

    private Widget load(Document document) {
        Assert.isNotNull((Object)document, (String)"null document can not init widget");
        Element el = document.getDocumentElement();
        Assert.isNotNull((Object)el, (String)"null document root can not init widget");
        return new Widget(el);
    }

    public void reloadEditableWidget() {
        if (this.underLyingModel != null) {
            IDOMModel dom = (IDOMModel)this.underLyingModel;
            IDOMDocument document = dom.getDocument();
            this.editableWidget.reload(document.getDocumentElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws CoreException {
        if (this.editableWidget != null && this.underLyingModel != null) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                CleanupProcessorXML cp = new CleanupProcessorXML();
                try {
                    cp.cleanupModel(this.underLyingModel);
                    this.underLyingModel.save();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error saving changes to config.xml", (Throwable)e));
                }
            }
        }
    }

    public Author createAuthor(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "author", Author.class);
    }

    public Content createContent(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "content", Content.class);
    }

    public Preference createPreference(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "preference", Preference.class);
    }

    public Feature createFeature(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "feature", Feature.class);
    }

    public Access createAccess(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "access", Access.class);
    }

    public Icon createIcon(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "icon", Icon.class);
    }

    public Splash createSplash(Widget widget) {
        return this.createObject(widget, null, "splash", Splash.class);
    }

    public License createLicense(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "license", License.class);
    }

    private <T extends AbstractConfigObject> T createObject(Widget widget, String namespace, String tag, Class<T> clazz) {
        if (widget != this.editableWidget) {
            throw new IllegalArgumentException("Widget model is not editable");
        }
        Document doc = widget.itemNode.getOwnerDocument();
        if (doc == null) {
            throw new IllegalStateException("Widget is not properly constructed");
        }
        Element el = doc.createElementNS(namespace, tag);
        try {
            return (T)((AbstractConfigObject)clazz.getDeclaredConstructor(Node.class).newInstance(el));
        }
        catch (Exception e) {
            HybridCore.log(4, "Error invoking the Node constructor for config model object", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPostModelEvent(ModelLifecycleEvent event) {
        if (event.getType() == 4 && !this.underLyingModel.isDirty()) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                this.reloadEditableWidget();
                this.readonlyWidget = null;
                this.readonlyTimestamp = -1L;
            }
        }
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
    }

    public synchronized void dispose() {
        if (this.underLyingModel != null) {
            this.underLyingModel.releaseFromEdit();
            this.underLyingModel = null;
        }
        this.editableWidget = null;
        this.readonlyWidget = null;
    }
}

