/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.CordovaPluginManager;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginVersion;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginSelectionPage;
import org.eclipse.thym.ui.plugins.internal.ICordovaPluginWizard;
import org.eclipse.thym.ui.plugins.internal.RegistryConfirmPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CordovaPluginWizard
extends Wizard
implements IWorkbenchWizard,
FileOverwriteCallback,
ICordovaPluginWizard {
    static final String IMAGE_WIZBAN = "/icons/wizban/cordova_plugin_wiz.png";
    private static final String DIALOG_SETTINGS_KEY = "CordovaPluginWizard";
    private CordovaPluginSelectionPage pageOne;
    private RegistryConfirmPage pageTwo;
    private IStructuredSelection initialSelection;
    private HybridProject fixedProject;
    private int initialSource;

    public CordovaPluginWizard() {
        this.setWindowTitle("Cordova Plug-in Discovery");
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public void init(HybridProject project, int initialSourceTab) {
        this.fixedProject = project;
        this.initialSource = initialSourceTab;
    }

    public boolean performFinish() {
        HybridProject project = HybridProject.getHybridProject((String)this.pageOne.getProjectName());
        if (project == null) {
            return false;
        }
        CordovaPluginManager pm = new CordovaPluginManager(project);
        PluginInstallOperation op = null;
        switch (this.pageOne.getPluginSourceType()) {
            case 3: {
                File directory = new File(this.pageOne.getSelectedDirectory());
                op = new PluginInstallOperation(directory, pm, (FileOverwriteCallback)this);
                break;
            }
            case 2: {
                URI uri = URI.create(this.pageOne.getSpecifiedGitURL());
                op = new PluginInstallOperation(uri, pm, (FileOverwriteCallback)this);
                break;
            }
            case 1: {
                List<CordovaRegistryPluginVersion> plugins = this.pageTwo.getSelectedPluginVersions();
                op = new PluginInstallOperation(plugins, pm, (FileOverwriteCallback)this);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"No valid plugin source can be determined");
            }
        }
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Plug-in installation problem", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Errors occured during plug-in installation", e.getTargetException()));
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.savePageSettings();
        return true;
    }

    public void addPages() {
        this.pageOne = this.fixedProject == null ? new CordovaPluginSelectionPage(this.initialSelection) : new CordovaPluginSelectionPage(this.fixedProject, this.initialSource);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new RegistryConfirmPage();
        this.addPage((IWizardPage)this.pageTwo);
    }

    @Override
    public WizardPage getRegistryConfirmPage() {
        return this.pageTwo;
    }

    HybridProject getFixedProject() {
        return this.fixedProject;
    }

    private void savePageSettings() {
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.setDialogSettings(section);
        this.pageOne.saveWidgetValues();
    }

    public boolean isOverwiteAllowed(String[] files) {
        final OverwriteDialog dialog = new OverwriteDialog(this.getShell(), files);
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() == 0;
    }

    @Override
    public boolean isPluginSelectionOptional() {
        return false;
    }

    private static class OverwriteDialog
    extends MessageDialog {
        public static final int YES_TO_ALL_INDEX = 0;
        private String[] paths;

        public OverwriteDialog(Shell parentShell, String[] paths) {
            super(parentShell, "Overwrite Files", null, "Listed files will be overwritten, would you like to proceed with the installation?", 3, new String[]{IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            this.paths = paths;
        }

        protected Control createCustomArea(Composite parent) {
            org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 4);
            int i = 0;
            while (i < this.paths.length) {
                list.add(this.paths[i]);
                ++i;
            }
            return list;
        }
    }

    private class PluginInstallOperation
    extends WorkspaceModifyOperation {
        private CordovaPluginManager pm;
        private int opType;
        private File dir;
        private URI gitRepo;
        private List<CordovaRegistryPluginVersion> plugins;
        private FileOverwriteCallback fileOverwriteCallback;

        private PluginInstallOperation(CordovaPluginManager pm, FileOverwriteCallback overwrite) {
            this.pm = pm;
            this.fileOverwriteCallback = overwrite;
        }

        public PluginInstallOperation(File directory, CordovaPluginManager pm, FileOverwriteCallback overwite) {
            this(pm, overwite);
            this.dir = directory;
            this.opType = 3;
        }

        public PluginInstallOperation(URI gitRepo, CordovaPluginManager pm, FileOverwriteCallback overwite) {
            this(pm, overwite);
            this.gitRepo = gitRepo;
            this.opType = 2;
        }

        public PluginInstallOperation(List<CordovaRegistryPluginVersion> plugins, CordovaPluginManager pm, FileOverwriteCallback overwite) {
            this(pm, overwite);
            this.plugins = plugins;
            this.opType = 1;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            switch (this.opType) {
                case 3: {
                    this.pm.installPlugin(this.dir, this.fileOverwriteCallback, monitor);
                    break;
                }
                case 2: {
                    this.pm.installPlugin(this.gitRepo, this.fileOverwriteCallback, false, monitor);
                    break;
                }
                case 1: {
                    for (CordovaRegistryPluginVersion cordovaRegistryPluginVersion : this.plugins) {
                        this.pm.installPlugin(cordovaRegistryPluginVersion, this.fileOverwriteCallback, false, monitor);
                    }
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"No valid plugin source can be determined");
                }
            }
        }
    }
}

