/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core.vstudio;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.eclipse.thym.wp.internal.core.Messages;
import org.eclipse.thym.wp.internal.core.vstudio.WPProjectUtils;

public class WPProjectGenerator
extends AbstractProjectGeneratorDelegate {
    private static final String GUID1 = "$guid1$";
    private static final String SAFE_PROJECT_NAME = "$safeprojectname$";
    private static final String PROPERTIES = "Properties";

    public WPProjectGenerator() {
    }

    public WPProjectGenerator(IProject project, File generationFolder, String platform) {
        this.init(project, generationFolder, platform);
    }

    protected void generateNativeFiles(HybridMobileLibraryResolver resolver) throws CoreException {
        try {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.WPProjectGenerator_NotHybridError));
            }
            File destinationDir = this.getDestination();
            Path destinationPath = new Path(destinationDir.toString());
            String appName = hybridProject.getBuildArtifactAppName();
            Widget widgetModel = WidgetModel.getModel((HybridProject)hybridProject).getWidgetForRead();
            String packageName = widgetModel.getId();
            if (!destinationDir.exists()) {
                destinationDir.mkdirs();
            }
            String safeAppName = appName.replaceAll("/(\\.\\s|\\s\\.|\\s+|\\.+)/g", "_");
            packageName = packageName.replaceAll("_", "-");
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationDir));
            org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)resolver.getTemplateFile((IPath)new Path("VERSION")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append("VERSION").toFile()));
            File configFile = this.getConfigFile(hybridProject.getProject());
            org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)configFile), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append("config.xml").toFile()));
            UUID guid = UUID.randomUUID();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(SAFE_PROJECT_NAME, appName);
            values.put(GUID1, guid.toString());
            IPath wpAppManifest = destinationPath.append(PROPERTIES).append("WMAppManifest.xml");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("WMAppManifest.xml")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)wpAppManifest.toFile()), values);
            values.clear();
            values.put(SAFE_PROJECT_NAME, packageName);
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("App.xaml")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append("App.xaml").toFile()), values);
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("App.xaml.cs")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append("App.xaml.cs").toFile()), values);
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("MainPage.xaml")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append("MainPage.xaml").toFile()), values);
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("MainPage.xaml.cs")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append("MainPage.xaml.cs").toFile()), values);
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("CordovaWP8AppProj.csproj")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append(String.valueOf(safeAppName) + ".csproj").toFile()), values);
            File defaultCsprojFile = destinationPath.append("CordovaWP8AppProj.csproj").toFile();
            if (defaultCsprojFile.exists()) {
                FileUtils.deleteQuietly((File)defaultCsprojFile);
            }
            values.put("CordovaWP8AppProj", safeAppName);
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("CordovaWP8Solution.sln")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)destinationPath.append(String.valueOf(safeAppName) + ".sln").toFile()), values);
            File defaultSlnFile = destinationPath.append("CordovaWP8Solution.sln").toFile();
            if (defaultSlnFile.exists()) {
                FileUtils.deleteQuietly((File)defaultSlnFile);
            }
            FileUtils.deleteQuietly((File)new File(destinationDir, "Bin"));
            FileUtils.deleteQuietly((File)new File(destinationDir, "obj"));
            FileUtils.deleteQuietly((File)new File(destinationDir, "__PreviewImage.jpg"));
            FileUtils.deleteQuietly((File)new File(destinationDir, "__TemplateIcon.png"));
            FileUtils.deleteQuietly((File)new File(destinationDir, "MyTemplate.vstemplate"));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.WPProjectGenerator_GenerationError, (Throwable)e));
        }
    }

    protected void replaceCordovaPlatformFiles(HybridMobileLibraryResolver resolver) throws IOException {
    }

    protected File getPlatformWWWDirectory() {
        return WPProjectUtils.getPlatformWWWDirectory(this.getDestination());
    }

    private File getConfigFile(IProject project) {
        IFile configFile = project.getFile(new Path("www").append("config.xml"));
        if (!configFile.exists()) {
            configFile = project.getFile("config.xml");
        }
        return configFile.getLocation().toFile();
    }
}

