/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.core.platform.AbstractPluginInstallationActionsFactory;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.actions.CopyFileAction;
import org.eclipse.thym.core.plugin.actions.CreateFileAction;
import org.eclipse.thym.core.plugin.actions.JSModuleAction;
import org.eclipse.thym.core.plugin.actions.XMLConfigFileAction;
import org.eclipse.thym.ios.core.xcode.IOSFrameworkAction;
import org.eclipse.thym.ios.core.xcode.IOSHeaderFileAction;
import org.eclipse.thym.ios.core.xcode.IOSResourceFileAction;
import org.eclipse.thym.ios.core.xcode.IOSSourceFileAction;
import org.eclipse.thym.ios.core.xcode.PlistConfigFileAction;
import org.eclipse.thym.ios.core.xcode.XCodeProjectUtils;

public class IOSPluginInstallationActionsFactory
extends AbstractPluginInstallationActionsFactory {
    public IPluginInstallationAction getSourceFileAction(String src, String targetDir, String framework, String pluginId, String compilerFlags) {
        File source = new File(this.getPluginDirectory(), src);
        StringBuilder targetPath = this.calculateTargetPath("Plugins", targetDir, pluginId, source);
        File target = new File(this.getProjectDirectory(), targetPath.toString());
        boolean isFramework = Boolean.parseBoolean(framework);
        File pbx = this.getPbxprojectFile();
        return new IOSSourceFileAction(source, target, pbx, targetPath.toString(), isFramework, compilerFlags);
    }

    public IPluginInstallationAction getResourceFileAction(String src, String taregt) {
        File source = new File(this.getPluginDirectory(), src);
        String targetPath = this.calculateTargetPath("Resources", null, null, source).toString();
        File target = new File(this.getProjectDirectory(), targetPath);
        File pbx = this.getPbxprojectFile();
        return new IOSResourceFileAction(source, target, pbx, targetPath);
    }

    public IPluginInstallationAction getHeaderFileAction(String src, String targetDir, String pluginId) {
        File source = new File(this.getPluginDirectory(), src);
        StringBuilder targetPath = this.calculateTargetPath("Plugins", targetDir, pluginId, source);
        File target = new File(this.getProjectDirectory(), targetPath.toString());
        File pbx = this.getPbxprojectFile();
        return new IOSHeaderFileAction(source, target, pbx, targetPath.toString());
    }

    public IPluginInstallationAction getAssetAction(String src, String target) {
        File sourceFile = new File(this.getPluginDirectory(), src);
        File targetFile = new File(XCodeProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), target);
        return new CopyFileAction(sourceFile, targetFile);
    }

    public IPluginInstallationAction getConfigFileAction(String target, String parent, String value) {
        File[] configFile = FileUtils.resolveFile((File)this.getProjectDirectory(), (String)target);
        File file = configFile[0];
        if (configFile.length == 1 && FilenameUtils.isExtension((String)file.toString(), (String)"plist")) {
            return new PlistConfigFileAction(file, parent, value);
        }
        if (configFile.length > 1) {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            String projectPfile = String.valueOf(hybridProject.getBuildArtifactAppName()) + "-Info.plist";
            File[] fileArray = configFile;
            int n = configFile.length;
            int n2 = 0;
            while (n2 < n) {
                File cfile = fileArray[n2];
                if (FilenameUtils.getBaseName((String)cfile.toString()).equals(projectPfile)) {
                    return new PlistConfigFileAction(cfile, parent, value);
                }
                ++n2;
            }
        }
        return new XMLConfigFileAction(file, parent, value);
    }

    public IPluginInstallationAction getLibFileAction(String src, String arch) {
        throw new UnsupportedOperationException("Not implemented for iOS");
    }

    public IPluginInstallationAction getFrameworkAction(String src, String weak, String pluginId, String custom, String type, String parent) {
        File pbx = this.getPbxprojectFile();
        boolean isWeak = Boolean.parseBoolean(weak);
        return new IOSFrameworkAction(src, isWeak, pbx);
    }

    public IPluginInstallationAction getJSModuleAction(String src, String pluginId, String jsModuleName) {
        File sourceFile = new File(this.getPluginDirectory(), src);
        File targetFile = new File(XCodeProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), "plugins" + File.separator + pluginId + File.separator + src);
        return new JSModuleAction(sourceFile, targetFile, jsModuleName);
    }

    public IPluginInstallationAction getCreatePluginJSAction(String content) {
        File pluginJs = new File(XCodeProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), "cordova_plugins.js");
        return new CreateFileAction(content, pluginJs);
    }

    private File getPbxprojectFile() {
        HybridProject project = HybridProject.getHybridProject((IProject)this.getProject());
        Assert.isNotNull((Object)project, (String)"Installation actions can not be created for non-hybrid project types");
        File pbx = new File(this.getProjectDirectory(), String.valueOf(project.getBuildArtifactAppName()) + ".xcodeproj/project.pbxproj");
        return pbx;
    }

    private StringBuilder calculateTargetPath(String groupDir, String targetDir, String pluginId, File source) {
        StringBuilder targetPath = new StringBuilder();
        HybridProject prj = HybridProject.getHybridProject((IProject)this.getProject());
        targetPath.append(prj.getBuildArtifactAppName()).append(File.separator);
        if (groupDir != null) {
            targetPath.append(groupDir).append(File.separator);
        }
        if (pluginId != null) {
            targetPath.append(pluginId).append(File.separator);
        }
        if (targetDir != null) {
            targetPath.append(targetDir).append(File.separator);
        }
        targetPath.append(source.getName());
        return targetPath;
    }
}

