/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.internal.util.BundleHttpCacheStorage;
import org.eclipse.thym.core.internal.util.HttpUtil;

public abstract class AbstractEngineRepoProvider {
    public abstract List<DownloadableCordovaEngine> getEngines() throws CoreException;

    protected InputStream getRemoteJSonStream(String url) {
        DefaultHttpClient defHttpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(defHttpClient);
        CachingHttpClient client = new CachingHttpClient((HttpClient)defHttpClient, (ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)new BundleHttpCacheStorage(HybridCore.getContext().getBundle()), this.cacheConfig());
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            return stream;
        }
        catch (IOException e) {
            HybridCore.log(2, NLS.bind((String)"Could not retrieve the json from remote URL ({0})", (Object)url), e);
            return null;
        }
    }

    protected List<DownloadableCordovaEngine> getEnginesFromStream(InputStream stream) throws IOException {
        ArrayList<DownloadableCordovaEngine> engines = new ArrayList<DownloadableCordovaEngine>();
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new InputStreamReader(stream));
            JsonParser parser = new JsonParser();
            JsonObject root = (JsonObject)parser.parse(reader);
            Set versions = root.entrySet();
            for (Map.Entry entry : versions) {
                JsonObject version = ((JsonElement)entry.getValue()).getAsJsonObject();
                DownloadableCordovaEngine engine = new DownloadableCordovaEngine();
                engine.setVersion((String)entry.getKey());
                Set libs = version.entrySet();
                for (Map.Entry lib : libs) {
                    DownloadableCordovaEngine.LibraryDownloadInfo info = new DownloadableCordovaEngine.LibraryDownloadInfo();
                    info.setPlatformId((String)lib.getKey());
                    JsonObject infoJsonObj = ((JsonElement)lib.getValue()).getAsJsonObject();
                    info.setDownloadURL(infoJsonObj.get("download_url").getAsString());
                    info.setVersion(infoJsonObj.get("version").getAsString());
                    engine.addLibraryInfo(info);
                }
                engines.add(engine);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return engines;
    }

    private CacheConfig cacheConfig() {
        CacheConfig config = new CacheConfig();
        config.setMaxObjectSize(122880L);
        return config;
    }
}

