/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.eclipse.thym.core.HybridCore;
import org.osgi.framework.Bundle;

public class BundleHttpCacheStorage
implements HttpCacheStorage {
    public static final String SUBDIR_HTTP_CACHE = "httpCache";
    private File cacheDir;

    public BundleHttpCacheStorage(Bundle bundle) {
        File f = bundle.getDataFile(SUBDIR_HTTP_CACHE);
        if (!f.exists()) {
            f.mkdir();
        }
        this.cacheDir = f;
    }

    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        ByteArrayOutputStream byteArrayOS = null;
        ObjectOutputStream objectOut = null;
        try {
            File f = this.getCacheFile(key);
            byteArrayOS = new ByteArrayOutputStream();
            objectOut = new ObjectOutputStream(byteArrayOS);
            objectOut.writeObject(entry);
            objectOut.flush();
            FileUtils.writeByteArrayToFile((File)f, (byte[])byteArrayOS.toByteArray());
        }
        finally {
            if (objectOut != null) {
                objectOut.close();
            }
            if (byteArrayOS != null) {
                byteArrayOS.close();
            }
        }
    }

    private File getCacheFile(String key) {
        String fileName = Integer.toHexString(key.hashCode());
        File f = new File(this.cacheDir, fileName);
        return f;
    }

    public HttpCacheEntry getEntry(String key) throws IOException {
        File f = this.getCacheFile(key);
        if (f.exists()) {
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            HttpCacheEntry entry = null;
            try {
                try {
                    byte[] bytes = FileUtils.readFileToByteArray((File)f);
                    bais = new ByteArrayInputStream(bytes);
                    ois = new ObjectInputStream(bais);
                    entry = (HttpCacheEntry)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    HybridCore.log(4, "Missing bundle", e);
                    if (ois != null) {
                        ois.close();
                    }
                    if (bais != null) {
                        bais.close();
                    }
                }
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
                if (bais != null) {
                    bais.close();
                }
            }
            return entry;
        }
        return null;
    }

    public void removeEntry(String key) throws IOException {
        File f = this.getCacheFile(key);
        FileUtils.deleteQuietly((File)f);
    }

    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
        HttpCacheEntry existing = this.getEntry(key);
        HttpCacheEntry updated = callback.update(existing);
        if (updated == null) {
            this.removeEntry(key);
        } else {
            this.putEntry(key, updated);
        }
    }
}

