/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document loadXML(File f) throws CoreException {
        return XMLUtil.loadXML(f, true);
    }

    public static Document loadXML(File f, boolean isNamespaceAware) throws CoreException {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory(isNamespaceAware);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(f);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser configuration error", (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Error when parsing file: {0}", (Object)f.toString()), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"IO error when parsing file: {0}", (Object)f.toString()), (Throwable)e));
        }
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory(boolean isNamespaceAware) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(isNamespaceAware);
        return dbf;
    }

    public static Document loadXML(InputStream source, boolean isNamespaceAware) throws CoreException {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory(isNamespaceAware);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser error when parsing ", (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser error ", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "IO error when parsing", (Throwable)e));
        }
    }

    public static Document loadXML(String content) throws CoreException {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory(false);
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(content)));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser error when parsing ", (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parsing error ", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "IO error when parsing ", (Throwable)e));
        }
    }

    public static void saveXML(File f, Document doc) throws CoreException {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(f);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer xformer = transformerFactory.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("method", "xml");
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error writing XML to file " + f.toString(), (Throwable)e));
        }
    }
}

