/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.XMLUtil;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.core.plugin.PluginJavaScriptModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class CordovaPluginXMLHelper {
    public static final String PLGN_PROPERTY_INFO = "info";
    public static final String PLGN_PROPERTY_KEYWORDS = "keywords";
    public static final String PLGN_PROPERTY_LICENSE = "license";
    public static final String PLGN_PROPERTY_NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String PLGN_PROPERTY_AUTHOR = "author";
    public static final String PLGN_PROPERTY_VERSION = "version";
    public static final String PLGN_PROPERTY_PLATFORM = "platform";
    public static final String PLGN_PROPERTY_ID = "id";

    public static Element getPlatformNode(Document document, String platform) {
        List<Element> nodes = CordovaPluginXMLHelper.getImmediateNodes(document.getDocumentElement(), PLGN_PROPERTY_PLATFORM);
        for (Element n : nodes) {
            String platformName = CordovaPluginXMLHelper.getAttributeValue(n, PLGN_PROPERTY_NAME);
            if (platformName == null || !platformName.equalsIgnoreCase(platform)) continue;
            return n;
        }
        return null;
    }

    public static List<Element> getSourceFileNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "source-file");
    }

    public static List<Element> getResourceFileNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "resource-file");
    }

    public static List<Element> getHeaderFileNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "header-file");
    }

    public static List<Element> getAssetNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "asset");
    }

    public static List<Element> getConfigFileNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "config-file");
    }

    public static List<Element> getPreferencesNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "preference");
    }

    public static List<Element> getLibFileNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "lib-file");
    }

    public static List<Element> getFrameworkNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "framework");
    }

    public static List<Element> getDependencyNodes(Element node) {
        return CordovaPluginXMLHelper.getImmediateNodes(node, "dependency");
    }

    public static Node getNameNode(Element node) {
        NodeList list = CordovaPluginXMLHelper.getNodes(node, PLGN_PROPERTY_NAME);
        if (list.getLength() == 1) {
            return list.item(0);
        }
        return null;
    }

    private static NodeList getNodes(Element element, String nodeName) {
        return element.getElementsByTagName(nodeName);
    }

    private static List<Element> getImmediateNodes(Element element, String nodeName) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && nodeName.equals(child.getNodeName())) {
                nodeList.add((Element)child);
            }
            child = child.getNextSibling();
        }
        return nodeList;
    }

    public static String getAttributeValue(Node node, String attribute) {
        Assert.isLegal((node != null ? 1 : 0) != 0, (String)"Null node value");
        NamedNodeMap map = node.getAttributes();
        Node attrib = map.getNamedItem(attribute);
        if (attrib == null) {
            return null;
        }
        return attrib.getNodeValue().trim();
    }

    public static String stringifyNode(Node node) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("xml-declaration", Boolean.FALSE);
            String str = writer.writeToString(node);
            return str;
        }
        catch (Exception e) {
            HybridCore.log(4, "Error resolving node for injection", e);
            return null;
        }
    }

    public static CordovaPlugin createCordovaPlugin(InputStream contents) throws CoreException {
        Document doc = XMLUtil.loadXML(contents, false);
        CordovaPlugin plugin = new CordovaPlugin();
        Element rootNode = doc.getDocumentElement();
        plugin.setId(CordovaPluginXMLHelper.getAttributeValue(rootNode, PLGN_PROPERTY_ID));
        plugin.setVersion(CordovaPluginXMLHelper.getAttributeValue(rootNode, PLGN_PROPERTY_VERSION));
        plugin.setAuthor(CordovaPluginXMLHelper.getChildNodeValue(rootNode, PLGN_PROPERTY_AUTHOR));
        plugin.setDescription(CordovaPluginXMLHelper.getChildNodeValue(rootNode, DESCRIPTION));
        plugin.setName(CordovaPluginXMLHelper.getChildNodeValue(rootNode, PLGN_PROPERTY_NAME));
        plugin.setLicense(CordovaPluginXMLHelper.getChildNodeValue(rootNode, PLGN_PROPERTY_LICENSE));
        plugin.setKeywords(CordovaPluginXMLHelper.getChildNodeValue(rootNode, PLGN_PROPERTY_KEYWORDS));
        plugin.setInfo(CordovaPluginXMLHelper.getChildNodeValue(rootNode, PLGN_PROPERTY_INFO));
        NodeList moduleNodes = CordovaPluginXMLHelper.getNodes(rootNode, "js-module");
        int i = 0;
        while (i < moduleNodes.getLength()) {
            Node n = moduleNodes.item(i);
            PluginJavaScriptModule module = new PluginJavaScriptModule();
            if (n.getParentNode().getNodeName().equals(PLGN_PROPERTY_PLATFORM)) {
                module.setPlatform(CordovaPluginXMLHelper.getAttributeValue(n.getParentNode(), PLGN_PROPERTY_NAME));
            }
            module.setName(String.valueOf(plugin.getId()) + "." + CordovaPluginXMLHelper.getAttributeValue(n, PLGN_PROPERTY_NAME));
            module.setSource(CordovaPluginXMLHelper.getAttributeValue(n, "src"));
            NodeList childNodes = n.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node item = childNodes.item(j);
                if (item.getNodeName().equals("runs")) {
                    module.setRuns(true);
                } else if (item.getNodeName().equals("merges")) {
                    module.addMerge(CordovaPluginXMLHelper.getAttributeValue(item, "target"));
                } else if (item.getNodeName().equals("clobbers")) {
                    module.addClobber(CordovaPluginXMLHelper.getAttributeValue(item, "target"));
                }
                ++j;
            }
            plugin.addModule(module);
            ++i;
        }
        NodeList engineNodes = CordovaPluginXMLHelper.getNodes(rootNode, "engine");
        int i2 = 0;
        while (i2 < engineNodes.getLength()) {
            Node engineNode = engineNodes.item(i2);
            String name = CordovaPluginXMLHelper.getAttributeValue(engineNode, PLGN_PROPERTY_NAME);
            String version = CordovaPluginXMLHelper.getAttributeValue(engineNode, PLGN_PROPERTY_VERSION);
            String platform = CordovaPluginXMLHelper.getAttributeValue(engineNode, PLGN_PROPERTY_PLATFORM);
            plugin.addSupportedEngine(name, version, platform);
            ++i2;
        }
        return plugin;
    }

    private static String getChildNodeValue(Element node, String tagName) {
        NodeList nodes = node.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent().trim();
        }
        return null;
    }
}

