/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.actions;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.platform.IPluginInstallationAction;

public class CopyFileAction
implements IPluginInstallationAction {
    protected final File source;
    protected final File target;

    public CopyFileAction(File source, File target) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)target);
        this.source = source;
        this.target = target;
    }

    @Override
    public void install() throws CoreException {
        try {
            if (this.source.isDirectory()) {
                FileUtils.copyDirectory((File)this.source, (File)this.target);
            } else if (this.target.exists()) {
                if (this.target.isDirectory()) {
                    FileUtils.copyFileToDirectory((File)this.source, (File)this.target);
                } else {
                    FileUtils.copyFile((File)this.source, (File)this.target);
                }
            } else if (FilenameUtils.getExtension((String)this.target.toString()).isEmpty()) {
                FileUtils.copyFileToDirectory((File)this.source, (File)this.target);
            } else {
                FileUtils.copyFile((File)this.source, (File)this.target);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error copying " + this.source + " to " + this.target, (Throwable)e));
        }
    }

    @Override
    public void unInstall() throws CoreException {
        File todelete = this.target;
        if (this.source.isFile() && this.target.isDirectory()) {
            todelete = new File(this.target, this.source.getName());
        }
        if (todelete.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)todelete);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error deleting file " + this.target, (Throwable)e));
            }
        }
        try {
            todelete.delete();
        }
        catch (SecurityException securityException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Could not delete " + this.target));
        }
    }

    @Override
    public String[] filesToOverwrite() {
        if (this.target.exists()) {
            File file;
            if (this.source.isFile() && this.target.isDirectory() && (file = new File(this.target, this.source.getName())).exists()) {
                return new String[]{file.toString()};
            }
            return new String[]{this.target.toString()};
        }
        return new String[0];
    }
}

