/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.android.core.adt.AndroidAPILevelComparator;
import org.eclipse.thym.android.core.adt.AndroidSDK;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.core.config.ImageResourceBase;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;

public class AndroidProjectUtils {
    public static File getPlatformWWWDirectory(File projectDirectory) {
        Assert.isNotNull((Object)projectDirectory);
        return new File(projectDirectory, "assets" + File.separator + "www");
    }

    public static AndroidSDK selectBestValidTarget(HybridMobileLibraryResolver resolver) throws CoreException {
        String file = resolver.getTemplateFile((IPath)new Path("framework/project.properties")).getFile();
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Active Cordova engine does not have a project.properties file"));
        }
        File projProps = new File(file);
        try {
            FileReader reader = new FileReader(projProps);
            Properties props = new Properties();
            props.load(reader);
            String targetValue = props.getProperty("target");
            int splitIndex = targetValue.indexOf(45);
            if (targetValue != null && splitIndex > -1) {
                AndroidAPILevelComparator alc = new AndroidAPILevelComparator();
                targetValue = targetValue.substring(splitIndex + 1);
                AndroidSDKManager sdkManager = AndroidSDKManager.getManager();
                List<AndroidSDK> targets = sdkManager.listTargets();
                for (AndroidSDK androidSDK : targets) {
                    if (alc.compare(targetValue, androidSDK.getApiLevel()) != 0) continue;
                    return androidSDK;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", NLS.bind((String)"Please install Android API level {0}. Use the Android SDK Manager to install or upgrade any missing SDKs to tools.", (Object)targetValue)));
            }
        }
        catch (FileNotFoundException e) {
            AndroidCore.log(2, "Missing project.properties for library", e);
        }
        catch (IOException e) {
            AndroidCore.log(2, "Failed to read target API level from library", e);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Could not determine required Android level for the Cordova engine, please use a different one"));
    }

    public static String getDensityForIcon(ImageResourceBase icon) {
        int size;
        if (icon == null) {
            return null;
        }
        String density = icon.getDensity();
        if ((density == null || density.isEmpty()) && (size = Math.max(icon.getHeight(), icon.getWidth())) > 0) {
            switch (size) {
                case 36: {
                    density = "ldpi";
                    break;
                }
                case 48: {
                    density = "mdpi";
                    break;
                }
                case 72: {
                    density = "hdpi";
                    break;
                }
                case 96: {
                    density = "xhdpi";
                    break;
                }
                case 144: {
                    density = "xxhdpi";
                    break;
                }
                case 192: {
                    density = "xxxhdpi";
                }
            }
        }
        return density;
    }
}

