/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.launch;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class HybridProjectLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        Object selected = ssel.getFirstElement();
        if (selected instanceof IAdaptable) {
            IResource resource;
            IAdaptable adaptable = (IAdaptable)selected;
            IProject project = (IProject)adaptable.getAdapter(IProject.class);
            if (project == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null) {
                project = resource.getProject();
            }
            if (project != null) {
                this.launch(project);
            } else {
                this.showEmptyError("Unable to determine a project to launch from selection.");
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
        if (file != null) {
            IProject project = file.getProject();
            this.launch(project);
        } else {
            this.showEmptyError("Unable to determine the project to launch for from the editor.");
        }
    }

    private void launch(IProject project) {
        try {
            if (!this.validateBuildToolsReady() || !this.shouldProceedWithLaunch(HybridProject.getHybridProject((IProject)project))) {
                return;
            }
            ILaunchConfiguration launchConfig = this.findOrCreateLaunchConfiguration(project);
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            this.updateLaunchConfiguration(wc);
            launchConfig = wc.doSave();
            DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)"run");
        }
        catch (CoreException e) {
            if (e.getCause() instanceof IOException) {
                Status status = new Status(4, "org.eclipse.thym.ui", "Unable to complete the build for target plarform", e.getCause());
                StatusManager.handle((IStatus)status);
            }
            StatusManager.handle(e);
        }
    }

    private void showEmptyError(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Launch Failed", (String)message);
    }

    private ILaunchConfiguration findOrCreateLaunchConfiguration(IProject project) throws CoreException {
        ILaunchConfiguration[] confs;
        ILaunchManager lm = this.getLaunchManager();
        ILaunchConfigurationType configType = this.getLaunchConfigurationType();
        ILaunchConfiguration[] iLaunchConfigurationArray = confs = lm.getLaunchConfigurations(configType);
        int n = confs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            if (this.isCorrectLaunchConfiguration(project, configuration)) {
                return configuration;
            }
            ++n2;
        }
        return this.createLaunchConfiguration(project);
    }

    private ILaunchConfiguration createLaunchConfiguration(IProject project) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationType().newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(this.getLaunchConfigurationNamePrefix(project)));
        wc.setAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", project.getName());
        return wc.doSave();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfigurationType getLaunchConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        String launchTypeID = this.getLaunchConfigurationTypeID();
        Assert.isNotNull((Object)launchTypeID);
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType(launchTypeID);
        return configType;
    }

    protected boolean isCorrectLaunchConfiguration(IProject project, ILaunchConfiguration config) throws CoreException {
        String projName = config.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
        return project.getName().equals(projName);
    }

    protected abstract boolean validateBuildToolsReady() throws CoreException;

    protected abstract String getLaunchConfigurationTypeID();

    protected boolean shouldProceedWithLaunch(HybridProject project) {
        return project != null;
    }

    protected abstract String getLaunchConfigurationNamePrefix(IProject var1);

    protected void updateLaunchConfiguration(ILaunchConfigurationWorkingCopy wc) {
    }
}

