/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryManager;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginViewer;

public class RegistryConfirmPage
extends WizardPage {
    private CordovaPluginViewer pluginViewer;
    private List<CordovaRegistryPluginInfo> selected;
    final CordovaPluginRegistryManager client = new CordovaPluginRegistryManager();
    private static final String PAGE_NAME = "Fetch from Registry";
    private static final String PAGE_TITLE = "Confirm plug-ins to be downloaded from registry";
    private static final String PAGE_DESC = "Confirm the plug-ins to be downloaded and installed from registry or go back to select again.";

    public RegistryConfirmPage() {
        super(PAGE_NAME, PAGE_TITLE, HybridUI.getImageDescriptor("org.eclipse.thym.ui", "/icons/wizban/cordova_plugin_wiz.png"));
        this.setDescription(PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.pluginViewer = new CordovaPluginViewer();
        this.pluginViewer.setHeaderVisible(false);
        this.pluginViewer.createControl(parent);
        this.setControl(this.pluginViewer.getControl());
        this.updatePluginViewerInput();
    }

    void setSelectedPlugins(List<CordovaRegistryPluginInfo> selected) {
        this.selected = selected;
        this.updatePluginViewerInput();
    }

    private void updatePluginViewerInput() {
        if (this.pluginViewer == null || this.selected == null) {
            return;
        }
        ArrayList<String> pluginNames = new ArrayList<String>(this.selected.size());
        for (CordovaRegistryPluginInfo cordovaRegistryPluginInfo : this.selected) {
            pluginNames.add(cordovaRegistryPluginInfo.getName());
        }
        DetailedPluginInfoRetrieveJob job = new DetailedPluginInfoRetrieveJob(pluginNames);
        job.schedule();
    }

    public List<CordovaRegistryPlugin.RegistryPluginVersion> getSelectedPluginVersions() {
        IStructuredSelection selection = this.pluginViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        return selection.toList();
    }

    private class DetailedPluginInfoRetrieveJob
    extends Job {
        private List<String> pluginNames;

        public DetailedPluginInfoRetrieveJob(List<String> pluginNames) {
            super("Retrieve Cordova Plug-in Details");
            this.pluginNames = pluginNames;
        }

        protected IStatus run(IProgressMonitor monitor) {
            final ArrayList<CordovaRegistryPlugin> plugins = new ArrayList<CordovaRegistryPlugin>();
            try {
                for (String plugin : this.pluginNames) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    plugins.add(RegistryConfirmPage.this.client.getCordovaPluginInfo(plugin));
                }
            }
            catch (CoreException e) {
                return new Status(e.getStatus().getSeverity(), "org.eclipse.thym.ui", "Problem while getting Cordova plugin details", (Throwable)e);
            }
            Control cntrl = RegistryConfirmPage.this.pluginViewer.getControl();
            if (!cntrl.isDisposed()) {
                cntrl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control c = RegistryConfirmPage.this.pluginViewer.getViewer().getControl();
                        if (c != null && !c.isDisposed()) {
                            RegistryConfirmPage.this.pluginViewer.getViewer().setInput((Object)plugins);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

