/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.TracingStreamListener;

public class ExternalProcessUtility {
    public void execAsync(String commandLine, File workingDirectory, IStreamListener outStreamListener, IStreamListener errorStreamListener, String[] envp) throws CoreException {
        HybridCore.trace("Async Execute command line: " + commandLine);
        String[] cmd = DebugPlugin.parseArguments((String)commandLine);
        Process process = DebugPlugin.exec((String[])cmd, (File)workingDirectory, (String[])envp);
        Launch launch = new Launch(null, "run", null);
        IProcess prcs = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)("Cordova Plugin:  " + cmd[0]));
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        if (HybridCore.DEBUG) {
            outStreamListener = new TracingStreamListener(outStreamListener);
            errorStreamListener = new TracingStreamListener(errorStreamListener);
        }
        if (outStreamListener != null) {
            prcs.getStreamsProxy().getOutputStreamMonitor().addListener(outStreamListener);
        }
        if (errorStreamListener != null) {
            prcs.getStreamsProxy().getErrorStreamMonitor().addListener(errorStreamListener);
        }
    }

    public int execSync(String commandLine, File workingDirectory, IStreamListener outStreamListener, IStreamListener errorStreamListener, IProgressMonitor monitor, String[] envp, ILaunchConfiguration launchConfiguration) throws CoreException {
        HybridCore.trace("Sync Execute command line: " + commandLine);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] cmd = DebugPlugin.parseArguments((String)commandLine);
        Process process = DebugPlugin.exec((String[])cmd, (File)workingDirectory, (String[])envp);
        Launch launch = new Launch(launchConfiguration, "run", null);
        IProcess prcs = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)("Cordova Plugin:  " + cmd[0]));
        if (launchConfiguration != null) {
            DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        }
        if (HybridCore.DEBUG) {
            HybridCore.trace("Creating TracingStreamListeners for " + commandLine);
            outStreamListener = new TracingStreamListener(outStreamListener);
            errorStreamListener = new TracingStreamListener(outStreamListener);
        }
        if (outStreamListener != null) {
            prcs.getStreamsProxy().getOutputStreamMonitor().addListener(outStreamListener);
        }
        if (errorStreamListener != null) {
            prcs.getStreamsProxy().getErrorStreamMonitor().addListener(errorStreamListener);
        }
        while (!prcs.isTerminated()) {
            try {
                if (monitor.isCanceled()) {
                    prcs.terminate();
                    break;
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                HybridCore.log(1, "Exception waiting for process to terminate", e);
            }
        }
        return prcs.getExitValue();
    }
}

