/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.XMLUtil;
import org.eclipse.thym.core.platform.AbstractPluginInstallationActionsFactory;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.core.plugin.CordovaPluginXMLHelper;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;
import org.eclipse.thym.core.plugin.PluginInstallActionsRunOperation;
import org.eclipse.thym.core.plugin.PluginJavaScriptModule;
import org.eclipse.thym.core.plugin.RestorableCordovaPlugin;
import org.eclipse.thym.core.plugin.actions.ActionVariableHelper;
import org.eclipse.thym.core.plugin.actions.ConfigXMLUpdateAction;
import org.eclipse.thym.core.plugin.actions.CopyFileAction;
import org.eclipse.thym.core.plugin.actions.DependencyInstallAction;
import org.eclipse.thym.core.plugin.actions.PluginInstallRecordAction;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryManager;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryMapper;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class CordovaPluginManager {
    private final HybridProject project;
    private List<CordovaPlugin> installedPlugins = new ArrayList<CordovaPlugin>();

    public CordovaPluginManager(HybridProject project) {
        this.project = project;
    }

    public void installPlugin(File directory, FileOverwriteCallback overwrite, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        Document doc = this.readPluginXML(directory);
        this.doInstallPlugin(directory, doc, overwrite, monitor);
        String id = CordovaPluginXMLHelper.getAttributeValue(doc.getDocumentElement(), "id");
        JsonObject source = new JsonObject();
        source.addProperty("type", "local");
        source.addProperty("path", directory.toString());
        this.saveFetchMetadata(source, id, monitor);
        ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>(1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("installPath", directory.toString());
        actions.add(this.getPluginInstallRecordAction(doc, params));
        this.runActions(actions, false, overwrite, monitor);
    }

    public void installPlugin(CordovaRegistryPlugin.RegistryPluginVersion plugin, FileOverwriteCallback overwrite, boolean isDependency, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        CordovaPluginRegistryManager regMgr = new CordovaPluginRegistryManager();
        File directory = regMgr.getInstallationDirectory(plugin, monitor);
        Document doc = this.readPluginXML(directory);
        this.doInstallPlugin(directory, doc, overwrite, monitor);
        String id = CordovaPluginXMLHelper.getAttributeValue(doc.getDocumentElement(), "id");
        JsonObject source = new JsonObject();
        source.addProperty("type", "registry");
        source.addProperty("id", id);
        this.saveFetchMetadata(source, id, monitor);
        if (!isDependency) {
            ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>(1);
            actions.add(this.getPluginInstallRecordAction(doc, null));
            this.runActions(actions, false, overwrite, monitor);
        }
    }

    public void installPlugin(URI uri, FileOverwriteCallback overwrite, boolean isDependency, IProgressMonitor monitor) throws CoreException {
        File tempRepoDirectory = new File(FileUtils.getTempDirectory(), "cordova_plugin_tmp_" + Long.toString(System.currentTimeMillis()));
        tempRepoDirectory.deleteOnExit();
        try {
            if (monitor.isCanceled()) {
                return;
            }
            try {
                monitor.subTask("Clone plugin repository");
                String gitUrl = String.valueOf(uri.getScheme()) + ":" + uri.getSchemeSpecificPart();
                Git git = Git.cloneRepository().setDirectory(tempRepoDirectory).setURI(gitUrl).call();
                File pluginDirectory = tempRepoDirectory;
                String fragment = uri.getFragment();
                String commit = null;
                String subdir = null;
                if (fragment != null) {
                    int idx = fragment.indexOf(58);
                    if (idx < 0) {
                        idx = fragment.length();
                    }
                    commit = fragment.substring(0, idx);
                    subdir = fragment.substring(Math.min(idx + 1, fragment.length()));
                    if (monitor.isCanceled()) {
                        throw new CanceledException("Plug-in installation cancelled");
                    }
                    if (commit != null && !commit.isEmpty()) {
                        git.checkout().setName(commit).call();
                    }
                    monitor.worked(1);
                    if (subdir != null && !subdir.isEmpty() && !(pluginDirectory = new File(tempRepoDirectory, subdir)).isDirectory()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"{0} directory does not exist in this git repository", (Object)subdir)));
                    }
                }
                SubProgressMonitor sm = new SubProgressMonitor(monitor, 1);
                Document doc = this.readPluginXML(pluginDirectory);
                this.doInstallPlugin(pluginDirectory, doc, overwrite, (IProgressMonitor)sm);
                String id = CordovaPluginXMLHelper.getAttributeValue(doc.getDocumentElement(), "id");
                JsonObject source = new JsonObject();
                source.addProperty("type", "git");
                source.addProperty("url", gitUrl);
                if (subdir != null && !subdir.isEmpty()) {
                    source.addProperty("subdir", subdir);
                }
                if (commit != null && !commit.isEmpty()) {
                    source.addProperty("ref", commit);
                }
                this.saveFetchMetadata(source, id, monitor);
                if (!isDependency) {
                    ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>(1);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("url", uri.toString());
                    actions.add(this.getPluginInstallRecordAction(doc, params));
                    this.runActions(actions, false, overwrite, monitor);
                }
            }
            catch (GitAPIException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error cloning the plugin repository", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void fixInstalledPlugin(CordovaPlugin plugin, FileOverwriteCallback overwrite, IProgressMonitor monitor) throws CoreException {
        IFolder pluginHome = this.getPluginHomeFolder(plugin);
        if (pluginHome == null) {
            return;
        }
        File directory = pluginHome.getLocation().toFile();
        Document doc = this.readPluginXML(directory);
        List<IPluginInstallationAction> actions = this.collectInstallActions(doc, plugin.getId(), overwrite);
        actions.add(this.getPluginInstallRecordAction(doc, null));
        this.runActions(actions, false, overwrite, monitor);
        this.resetInstalledPlugins();
    }

    private void doInstallPlugin(File directory, Document doc, FileOverwriteCallback overwrite, IProgressMonitor monitor) throws CoreException {
        IFolder plugins;
        String id = CordovaPluginXMLHelper.getAttributeValue(doc.getDocumentElement(), "id");
        if (this.isPluginInstalled(id)) {
            HybridCore.log(2, "Cordova Plugin (" + id + ") is already installed, skipping.", null);
        }
        if (!(plugins = this.getPluginsFolder()).exists()) {
            plugins.create(true, true, monitor);
        }
        ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>();
        File destination = new File(plugins.getLocation().toFile(), id);
        CopyFileAction copy = new CopyFileAction(directory, destination);
        actions.add(copy);
        actions.addAll(this.collectInstallActions(doc, id, overwrite));
        this.runActions(actions, false, overwrite, monitor);
        this.resetInstalledPlugins();
    }

    private Document readPluginXML(File directory) throws CoreException {
        File pluginFile = new File(directory, "plugin.xml");
        if (!pluginFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"plugin.xml can not be located at {0}", (Object)pluginFile.toString())));
        }
        Document doc = null;
        try {
            doc = XMLUtil.loadXML(pluginFile, false);
        }
        catch (CoreException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                HybridMobileStatus hms = new HybridMobileStatus(4, "org.eclipse.thym.core", 423, e.getStatus().getMessage(), e.getCause());
                e = new CoreException((IStatus)hms);
            }
            throw e;
        }
        return doc;
    }

    private void saveFetchMetadata(JsonObject source, String id, IProgressMonitor monitor) throws CoreException {
        IFolder pluginHome = this.getPluginHomeFolder(id);
        if (pluginHome == null) {
            return;
        }
        IFile file = pluginHome.getFile(".fetch.json");
        JsonObject object = new JsonObject();
        object.add("source", (JsonElement)source);
        Gson gson = new Gson();
        String jsonString = gson.toJson((JsonElement)object);
        ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)stream, 1, monitor);
        } else {
            file.create((InputStream)stream, true, monitor);
        }
    }

    public void unInstallPlugin(String id, IProgressMonitor monitor) throws CoreException {
        if (id == null || !this.isPluginInstalled(id)) {
            return;
        }
        IFolder dir = this.getPluginHomeFolder(id);
        File pluginFile = new File(dir.getLocation().toFile(), "plugin.xml");
        if (!pluginFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Not a valid plugin id , no plugin.xml exists"));
        }
        Document doc = XMLUtil.loadXML(pluginFile, false);
        FileOverwriteCallback cb = new FileOverwriteCallback(){

            @Override
            public boolean isOverwiteAllowed(String[] files) {
                return true;
            }
        };
        ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>();
        File destination = new File(this.getPluginsFolder().getLocation().toFile(), id);
        CopyFileAction copy = new CopyFileAction(dir.getLocation().toFile(), destination);
        actions.add(copy);
        actions.addAll(this.collectInstallActions(doc, id, cb));
        actions.add(this.getPluginInstallRecordAction(doc, null));
        this.runActions(actions, true, cb, monitor);
        this.resetInstalledPlugins();
    }

    private void resetInstalledPlugins() {
        this.installedPlugins.clear();
    }

    public void completePluginInstallationsForPlatform(File platformProjectLocation, String platform, FileOverwriteCallback overwrite, IProgressMonitor monitor) throws CoreException {
        List<CordovaPlugin> plugins = this.getInstalledPlugins();
        PlatformSupport platformSupport = HybridCore.getPlatformSupport(platform);
        for (CordovaPlugin cordovaPlugin : plugins) {
            this.completePluginInstallationToPlatform(cordovaPlugin, platformSupport, platformProjectLocation, overwrite, monitor);
        }
    }

    public List<CordovaPlugin> getInstalledPlugins() throws CoreException {
        this.updatePluginList();
        return Collections.unmodifiableList(this.installedPlugins);
    }

    public boolean isPluginInstalled(String pluginId) {
        if (pluginId == null) {
            return false;
        }
        try {
            IFolder pluginHome = this.getPluginHomeFolder(pluginId);
            if (pluginHome != null) {
                IFile pluginxml = pluginHome.getFile("plugin.xml");
                return pluginxml.getLocation() != null && pluginHome.getLocation().toFile().exists();
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public String getCordovaPluginJSContent(String platformId) throws CoreException {
        JsonArray moduleObjects = new JsonArray();
        List<CordovaPlugin> plugins = this.getInstalledPlugins();
        for (CordovaPlugin cordovaPlugin : plugins) {
            List<PluginJavaScriptModule> modules = cordovaPlugin.getModules();
            for (PluginJavaScriptModule pluginJavaScriptModule : modules) {
                if (platformId != null && pluginJavaScriptModule.getPlatform() != null && !pluginJavaScriptModule.getPlatform().equals(platformId)) continue;
                JsonObject obj = new JsonObject();
                obj.addProperty("file", new Path("plugins").append(cordovaPlugin.getId()).append(pluginJavaScriptModule.getSource()).toString());
                obj.addProperty("id", pluginJavaScriptModule.getName());
                if (pluginJavaScriptModule.isRuns()) {
                    obj.addProperty("runs", Boolean.valueOf(true));
                }
                if (pluginJavaScriptModule.getClobbers() != null) {
                    List<String> clobbers = pluginJavaScriptModule.getClobbers();
                    JsonArray clobbersArray = new JsonArray();
                    for (String string : clobbers) {
                        clobbersArray.add((JsonElement)new JsonPrimitive(string));
                    }
                    obj.add("clobbers", (JsonElement)clobbersArray);
                }
                if (pluginJavaScriptModule.getMerges() != null) {
                    List<String> merges = pluginJavaScriptModule.getMerges();
                    JsonArray mergesArray = new JsonArray();
                    for (String string : merges) {
                        mergesArray.add((JsonElement)new JsonPrimitive(string));
                    }
                    obj.add("merges", (JsonElement)mergesArray);
                }
                moduleObjects.add((JsonElement)obj);
            }
        }
        StringBuilder finalContents = new StringBuilder();
        finalContents.append("cordova.define('cordova/plugin_list', function(require, exports, module) {\n");
        Gson gson = new Gson();
        finalContents.append("module.exports = ").append(gson.toJson((JsonElement)moduleObjects)).append("\n});");
        return finalContents.toString();
    }

    public List<RestorableCordovaPlugin> getRestorablePlugins(IProgressMonitor monitor) throws CoreException {
        Widget widget = WidgetModel.getModel(this.project).getWidgetForRead();
        if (widget == null) {
            HybridCore.log(4, "Unable to read config.xml for restorable plugins", null);
            return Collections.emptyList();
        }
        List<Feature> features = widget.getFeatures();
        ArrayList<RestorableCordovaPlugin> restorable = new ArrayList<RestorableCordovaPlugin>();
        if (features != null) {
            for (Feature feature : features) {
                String path;
                String url;
                Map<String, String> params = feature.getParams();
                String id = params.get("id");
                String newId = CordovaPluginRegistryMapper.toNew(id);
                if (newId != null) {
                    id = newId;
                }
                if (id == null || this.isPluginInstalled(id)) continue;
                RestorableCordovaPlugin rp = new RestorableCordovaPlugin();
                rp.setId(id);
                rp.setType(RestorableCordovaPlugin.Type.REGISTRY);
                String version = params.get("version");
                if (version != null) {
                    rp.setVersion(version);
                }
                if ((url = params.get("url")) != null) {
                    rp.setUrl(url);
                    rp.setType(RestorableCordovaPlugin.Type.GIT);
                }
                if ((path = params.get("installPath")) != null) {
                    rp.setPath(path);
                    rp.setType(RestorableCordovaPlugin.Type.LOCAL);
                }
                restorable.add(rp);
            }
        }
        return restorable;
    }

    private List<IPluginInstallationAction> collectInstallActions(Document doc, String id, FileOverwriteCallback overwrite) {
        ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>();
        actions.addAll(this.collectDependencyActions(doc.getDocumentElement(), overwrite));
        actions.addAll(this.collectConfigXMLActions(doc.getDocumentElement()));
        actions.addAll(this.collectVariablePreferences(doc.getDocumentElement()));
        List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
        for (PlatformSupport platformSupport : platforms) {
            Element platformNode = CordovaPluginXMLHelper.getPlatformNode(doc, platformSupport.getPlatformId());
            if (platformNode == null) continue;
            actions.addAll(this.collectDependencyActions(platformNode, overwrite));
            actions.addAll(this.collectConfigXMLActions(platformNode));
            actions.addAll(this.collectVariablePreferences(platformNode));
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePluginList() throws CoreException {
        long start = System.currentTimeMillis();
        if (this.installedPlugins == null || this.installedPlugins.isEmpty()) {
            HybridCore.trace("Really updating the installed plugin list");
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFolder folder;
                    IFile file;
                    if (resource.getType() == 2 && (file = (folder = (IFolder)resource.getAdapter(IFolder.class)).getFile("plugin.xml")).exists()) {
                        CordovaPluginManager.this.addInstalledPlugin(file);
                    }
                    return resource.getName().equals("plugins");
                }
            };
            IFolder plugins = this.project.getProject().getFolder("plugins");
            if (plugins != null && plugins.exists()) {
                List<CordovaPlugin> list = this.installedPlugins;
                synchronized (list) {
                    plugins.accept(visitor, 1, false);
                }
            }
        }
        HybridCore.trace(NLS.bind((String)"Updated plugin list in {0} ms", (Object)(System.currentTimeMillis() - start)));
    }

    private void addInstalledPlugin(IFile pluginxml) throws CoreException {
        CordovaPlugin plugin = CordovaPluginXMLHelper.createCordovaPlugin(pluginxml.getContents());
        plugin.setFolder((IFolder)pluginxml.getParent().getAdapter(IFolder.class));
        int index = this.installedPlugins.indexOf((Object)plugin);
        if (index > -1) {
            this.installedPlugins.set(index, plugin);
        } else {
            this.installedPlugins.add(plugin);
        }
    }

    private IFolder getPluginHomeFolder(CordovaPlugin plugin) throws CoreException {
        if (plugin == null) {
            return null;
        }
        return this.getPluginHomeFolder(plugin.getId());
    }

    private IFolder getPluginHomeFolder(String id) throws CoreException {
        if (id == null) {
            return null;
        }
        IFolder plugins = this.getPluginsFolder();
        if (!plugins.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Plugin folder does not exist"));
        }
        IFolder pluginHome = plugins.getFolder(id);
        IPath location = pluginHome.getLocation();
        if (pluginHome.exists() && location != null && location.toFile().isDirectory()) {
            return pluginHome;
        }
        String alternateId = CordovaPluginRegistryMapper.alternateID(id);
        if (alternateId != null) {
            pluginHome = plugins.getFolder(alternateId);
            location = pluginHome.getLocation();
            if (pluginHome.exists() && location != null && location.toFile().isDirectory()) {
                return pluginHome;
            }
        }
        return null;
    }

    private IFolder getPluginsFolder() {
        IFolder plugins = this.project.getProject().getFolder("plugins");
        return plugins;
    }

    private void runActions(List<IPluginInstallationAction> actions, boolean runUnInstall, FileOverwriteCallback overwrite, IProgressMonitor monitor) throws CoreException {
        PluginInstallActionsRunOperation op = new PluginInstallActionsRunOperation(actions, runUnInstall, overwrite, this.project.getProject());
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
    }

    private void completePluginInstallationToPlatform(CordovaPlugin plugin, PlatformSupport platform, File platformProject, FileOverwriteCallback overwrite, IProgressMonitor monitor) throws CoreException {
        if (platform == null) {
            return;
        }
        IFolder pluginHomeFolder = this.getPluginHomeFolder(plugin);
        if (pluginHomeFolder == null) {
            return;
        }
        File pluginHome = pluginHomeFolder.getLocation().toFile();
        File pluginFile = new File(pluginHome, "plugin.xml");
        Document doc = XMLUtil.loadXML(pluginFile, false);
        ArrayList<IPluginInstallationAction> allActions = new ArrayList<IPluginInstallationAction>();
        AbstractPluginInstallationActionsFactory actionFactory = platform.getPluginInstallationActionsFactory(this.project.getProject(), pluginHome, platformProject);
        allActions.addAll(this.collectCommonAndPlatformJSModuleActions(plugin, platform.getPlatformId(), actionFactory));
        allActions.addAll(this.collectAssetActions(doc.getDocumentElement(), actionFactory));
        allActions.addAll(this.collectConfigFileActions(doc.getDocumentElement(), actionFactory));
        allActions.addAll(this.collectSourceFilesActions(doc.getDocumentElement(), actionFactory));
        allActions.addAll(this.collectResourceFileActions(doc.getDocumentElement(), actionFactory));
        allActions.addAll(this.collectHeaderFileActions(doc.getDocumentElement(), actionFactory));
        allActions.addAll(this.collectLibFileActions(doc.getDocumentElement(), actionFactory));
        allActions.addAll(this.collectFrameworkActions(doc.getDocumentElement(), actionFactory, plugin));
        Element node = CordovaPluginXMLHelper.getPlatformNode(doc, platform.getPlatformId());
        if (node != null) {
            allActions.addAll(this.collectAssetActions(node, actionFactory));
            allActions.addAll(this.collectConfigFileActions(node, actionFactory));
            allActions.addAll(this.collectSourceFilesActions(node, actionFactory));
            allActions.addAll(this.collectResourceFileActions(node, actionFactory));
            allActions.addAll(this.collectHeaderFileActions(node, actionFactory));
            allActions.addAll(this.collectLibFileActions(node, actionFactory));
            allActions.addAll(this.collectFrameworkActions(node, actionFactory, plugin));
        }
        allActions.add(actionFactory.getCreatePluginJSAction(this.getCordovaPluginJSContent(platform.getPlatformId())));
        this.runActions(allActions, false, overwrite, monitor);
    }

    private List<IPluginInstallationAction> collectCommonAndPlatformJSModuleActions(CordovaPlugin plugin, String platformId, AbstractPluginInstallationActionsFactory factory) {
        List<PluginJavaScriptModule> modules = plugin.getModules();
        ArrayList<IPluginInstallationAction> actions = new ArrayList<IPluginInstallationAction>();
        for (PluginJavaScriptModule scriptModule : modules) {
            if (scriptModule.getPlatform() != null && !scriptModule.getPlatform().equals(platformId)) continue;
            IPluginInstallationAction action = factory.getJSModuleAction(scriptModule.getSource(), plugin.getId(), scriptModule.getName());
            actions.add(action);
        }
        return actions;
    }

    private List<IPluginInstallationAction> collectConfigXMLActions(Element node) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> configFiles = CordovaPluginXMLHelper.getConfigFileNodes(node);
        for (Element current : configFiles) {
            String target = CordovaPluginXMLHelper.getAttributeValue(current, "target");
            if (!target.endsWith("config.xml")) continue;
            String parent = CordovaPluginXMLHelper.getAttributeValue(current, "parent");
            String resolvedValue = CordovaPluginXMLHelper.stringifyNode(current);
            try {
                resolvedValue = ActionVariableHelper.replaceVariables(this.project, resolvedValue);
            }
            catch (CoreException ex) {
                HybridCore.log(4, "Error while resolving variables", ex);
            }
            ConfigXMLUpdateAction action = new ConfigXMLUpdateAction(this.project, parent, resolvedValue);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectVariablePreferences(Element node) {
        List<Element> preferences = CordovaPluginXMLHelper.getPreferencesNodes(node);
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        for (Element current : preferences) {
            String name = CordovaPluginXMLHelper.getAttributeValue(current, "name");
            ConfigXMLUpdateAction action = new ConfigXMLUpdateAction(this.project, "/widget", " <config-file target=\"res/xml/config.xml\" parent=\"/widget\"><preference name=\"" + name + "\" value=\"PLEASE_DEFINE\"/>" + "</config-file>");
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectDependencyActions(Element node, FileOverwriteCallback overwrite) {
        List<Element> dependencyNodes = CordovaPluginXMLHelper.getDependencyNodes(node);
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        for (Element dependencyNode : dependencyNodes) {
            String dependencyId = CordovaPluginXMLHelper.getAttributeValue(dependencyNode, "id");
            String url = CordovaPluginXMLHelper.getAttributeValue(dependencyNode, "url");
            String commit = CordovaPluginXMLHelper.getAttributeValue(dependencyNode, "commit");
            String subdir = CordovaPluginXMLHelper.getAttributeValue(dependencyNode, "subdir");
            URI uri = null;
            if (url != null && !url.isEmpty()) {
                if (!url.endsWith(".git")) {
                    url = String.valueOf(url) + ".git";
                }
                if (commit != null || subdir != null) {
                    url = String.valueOf(url) + "#";
                    if (commit != null) {
                        url = String.valueOf(url) + commit;
                    }
                    if (subdir != null) {
                        url = String.valueOf(url) + ":" + subdir;
                    }
                }
                uri = URI.create(url);
            }
            DependencyInstallAction action = new DependencyInstallAction(dependencyId, uri, this.project, overwrite);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectFrameworkActions(Element node, AbstractPluginInstallationActionsFactory factory, CordovaPlugin plugin) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> frameworks = CordovaPluginXMLHelper.getFrameworkNodes(node);
        for (Element current : frameworks) {
            String src = CordovaPluginXMLHelper.getAttributeValue(current, "src");
            String weak = CordovaPluginXMLHelper.getAttributeValue(current, "weak");
            String custom = CordovaPluginXMLHelper.getAttributeValue(current, "custom");
            String type = CordovaPluginXMLHelper.getAttributeValue(current, "type");
            String parent = CordovaPluginXMLHelper.getAttributeValue(current, "parent");
            IPluginInstallationAction action = factory.getFrameworkAction(src, weak, plugin.getId(), custom, type, parent);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectLibFileActions(Element node, AbstractPluginInstallationActionsFactory factory) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> libFiles = CordovaPluginXMLHelper.getLibFileNodes(node);
        for (Element current : libFiles) {
            String src = CordovaPluginXMLHelper.getAttributeValue(current, "src");
            String arch = CordovaPluginXMLHelper.getAttributeValue(current, "arch");
            IPluginInstallationAction action = factory.getLibFileAction(src, arch);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectConfigFileActions(Element node, AbstractPluginInstallationActionsFactory factory) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> configFiles = CordovaPluginXMLHelper.getConfigFileNodes(node);
        for (Element current : configFiles) {
            String target = CordovaPluginXMLHelper.getAttributeValue(current, "target");
            if (target.endsWith("config.xml")) continue;
            String parent = CordovaPluginXMLHelper.getAttributeValue(current, "parent");
            String resolvedValue = CordovaPluginXMLHelper.stringifyNode(current);
            try {
                resolvedValue = ActionVariableHelper.replaceVariables(this.project, resolvedValue);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Error while resolving the variables", e);
            }
            IPluginInstallationAction action = factory.getConfigFileAction(target, parent, resolvedValue);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectHeaderFileActions(Element node, AbstractPluginInstallationActionsFactory factory) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> headerFiles = CordovaPluginXMLHelper.getHeaderFileNodes(node);
        for (Element current : headerFiles) {
            String src = CordovaPluginXMLHelper.getAttributeValue(current, "src");
            String targetDir = CordovaPluginXMLHelper.getAttributeValue(current, "target-dir");
            String id = CordovaPluginXMLHelper.getAttributeValue(node.getOwnerDocument().getDocumentElement(), "id");
            IPluginInstallationAction action = factory.getHeaderFileAction(src, targetDir, id);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectResourceFileActions(Element node, AbstractPluginInstallationActionsFactory factory) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> resourceFiles = CordovaPluginXMLHelper.getResourceFileNodes(node);
        for (Element current : resourceFiles) {
            String src = CordovaPluginXMLHelper.getAttributeValue(current, "src");
            String target = CordovaPluginXMLHelper.getAttributeValue(current, "target");
            IPluginInstallationAction action = factory.getResourceFileAction(src, target);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectSourceFilesActions(Element node, AbstractPluginInstallationActionsFactory factory) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> sourceFiles = CordovaPluginXMLHelper.getSourceFileNodes(node);
        for (Element current : sourceFiles) {
            String src = CordovaPluginXMLHelper.getAttributeValue(current, "src");
            String targetDir = CordovaPluginXMLHelper.getAttributeValue(current, "target-dir");
            String framework = CordovaPluginXMLHelper.getAttributeValue(current, "framework");
            String compilerFlags = CordovaPluginXMLHelper.getAttributeValue(current, "compiler-flags");
            String id = CordovaPluginXMLHelper.getAttributeValue(node.getOwnerDocument().getDocumentElement(), "id");
            IPluginInstallationAction action = factory.getSourceFileAction(src, targetDir, framework, id, compilerFlags);
            list.add(action);
        }
        return list;
    }

    private List<IPluginInstallationAction> collectAssetActions(Element node, AbstractPluginInstallationActionsFactory factory) {
        ArrayList<IPluginInstallationAction> list = new ArrayList<IPluginInstallationAction>();
        List<Element> assets = CordovaPluginXMLHelper.getAssetNodes(node);
        for (Element current : assets) {
            String src = CordovaPluginXMLHelper.getAttributeValue(current, "src");
            String target = CordovaPluginXMLHelper.getAttributeValue(current, "target");
            IPluginInstallationAction action = factory.getAssetAction(src, target);
            list.add(action);
        }
        return list;
    }

    private PluginInstallRecordAction getPluginInstallRecordAction(Document pluginXml, Map<String, String> additionalParams) throws CoreException {
        Node n;
        HashMap<String, String> params = new HashMap<String, String>();
        if (additionalParams != null) {
            params.putAll(additionalParams);
        }
        String id = CordovaPluginXMLHelper.getAttributeValue(pluginXml.getDocumentElement(), "id");
        params.put("id", id);
        boolean saveVersion = Platform.getPreferencesService().getBoolean("org.eclipse.thym.ui", "shrinkwrap_plugin_version", false, null);
        String version = null;
        if (saveVersion) {
            version = CordovaPluginXMLHelper.getAttributeValue(pluginXml.getDocumentElement(), "version");
            params.put("version", version);
        }
        if ((n = CordovaPluginXMLHelper.getNameNode(pluginXml.getDocumentElement())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "plugin.xml is missing name"));
        }
        return new PluginInstallRecordAction(this.project, n.getTextContent().trim(), params);
    }
}

