/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.android.core.adt.AndroidFrameworkAction;
import org.eclipse.thym.android.core.adt.AndroidProjectUtils;
import org.eclipse.thym.android.core.adt.AndroidSDK;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.platform.AbstractPluginInstallationActionsFactory;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.actions.CopyFileAction;
import org.eclipse.thym.core.plugin.actions.CreateFileAction;
import org.eclipse.thym.core.plugin.actions.JSModuleAction;
import org.eclipse.thym.core.plugin.actions.XMLConfigFileAction;

public class AndroidPluginInstallationActionsFactory
extends AbstractPluginInstallationActionsFactory {
    public IPluginInstallationAction getSourceFileAction(String src, String targetDir, String framework, String pluginId, String compilerFlags) {
        File source = new File(this.getPluginDirectory(), src);
        File target = new File(this.getProjectDirectory(), targetDir);
        return new AndroidSourceFileAction(source, target);
    }

    public IPluginInstallationAction getResourceFileAction(String src, String target) {
        File source = new File(this.getPluginDirectory(), src);
        File targetDir = new File(this.getProjectDirectory(), target);
        return new CopyFileAction(source, targetDir);
    }

    public IPluginInstallationAction getHeaderFileAction(String src, String targetDir, String pluginId) {
        throw new UnsupportedOperationException("Not implemented for Android");
    }

    public IPluginInstallationAction getAssetAction(String src, String target) {
        File source = new File(this.getPluginDirectory(), src);
        File targetDir = new File(AndroidProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), target);
        return new CopyFileAction(source, targetDir);
    }

    public IPluginInstallationAction getConfigFileAction(String target, String parent, String value) {
        File[] files = org.eclipse.thym.core.internal.util.FileUtils.resolveFile((File)this.getProjectDirectory(), (String)target);
        return new XMLConfigFileAction(files[0], parent, value);
    }

    public IPluginInstallationAction getLibFileAction(String src, String arch) {
        File source = new File(this.getPluginDirectory(), src);
        File target = new File(this.getProjectDirectory(), "libs");
        if (!target.isDirectory()) {
            target.mkdir();
        }
        CopyFileAction action = new CopyFileAction(source, target);
        return action;
    }

    public IPluginInstallationAction getFrameworkAction(String src, String weak, String pluginId, String custom, String type, String parent) {
        if (src == null) {
            throw new IllegalArgumentException("src not specified in framework element");
        }
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
        AndroidSDK sdk = null;
        try {
            HybridMobileEngine activeEngineForPlatform = hybridProject.getActiveEngineForPlatform("android");
            Assert.isNotNull((Object)activeEngineForPlatform);
            sdk = AndroidProjectUtils.selectBestValidTarget(activeEngineForPlatform.getResolver());
        }
        catch (CoreException e) {
            AndroidCore.log(4, "Framework action fails to select a target", e);
        }
        return new AndroidFrameworkAction(src, custom, parent, pluginId, this.getProjectDirectory(), this.getPluginDirectory(), sdk);
    }

    public IPluginInstallationAction getJSModuleAction(String src, String pluginId, String jsModuleName) {
        File source = new File(this.getPluginDirectory(), src);
        File target = new File(AndroidProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), "plugins" + File.separator + pluginId + File.separator + src);
        JSModuleAction action = new JSModuleAction(source, target, jsModuleName);
        return action;
    }

    public IPluginInstallationAction getCreatePluginJSAction(String content) {
        File pluginJs = new File(AndroidProjectUtils.getPlatformWWWDirectory(this.getProjectDirectory()), "cordova_plugins.js");
        CreateFileAction action = new CreateFileAction(content, pluginJs);
        return action;
    }

    public static class AndroidSourceFileAction
    extends CopyFileAction {
        private File target;

        public AndroidSourceFileAction(File source, File target) {
            super(source, target);
            this.target = target;
        }

        public void unInstall() throws CoreException {
            super.unInstall();
            File dir = this.findHighestEmptyParent(this.target);
            try {
                if (dir.isDirectory()) {
                    FileUtils.deleteDirectory((File)dir);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Error deleting package name structure", (Throwable)e));
            }
        }

        private File findHighestEmptyParent(File file) {
            File parent = file.getParentFile();
            if (parent == null) {
                return file;
            }
            File[] children = parent.listFiles();
            if (children.length > 1) {
                return file;
            }
            return this.findHighestEmptyParent(parent);
        }
    }
}

