/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.core.vstudio;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;
import org.eclipse.thym.wp.internal.core.Messages;
import org.eclipse.thym.wp.internal.core.Version;
import org.eclipse.thym.wp.internal.core.WindowsRegistry;
import org.eclipse.thym.wp.internal.core.vstudio.WPProjectGenerator;
import org.eclipse.thym.wp.internal.core.vstudio.WPProjectUtils;

public class MSBuild
extends AbstractNativeBinaryBuildDelegate {
    private static final String DEBUG_XAP_NAME = "CordovaAppProj_Debug_AnyCPU.xap";
    private static final String RELEASE_XAP_NAME = "CordovaAppProj_Release_AnyCPU.xap";
    private static final String WP_CORDOVA_CLASS_LIB_DLL = "WPCordovaClassLib.dll";
    private static final String INSTALL_ROOT = "InstallRoot";
    private static final String DOT_NET = "HKLM\\Software\\Wow6432Node\\Microsoft\\.NETFramework";
    private ILaunchConfiguration launchConfiguration;

    public void buildLibraryProject(File projectLocation, IProgressMonitor monitor) throws CoreException {
        this.doBuildProject(projectLocation, monitor);
        this.setBuildArtifact(new File(this.getBuildDir(projectLocation), WP_CORDOVA_CLASS_LIB_DLL));
        if (!this.getBuildArtifact().exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.MSBuild_MSBuildFailedMessage));
        }
    }

    public void buildNow(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask(Messages.MSBuild_BuildProjectTask, 10);
            WPProjectGenerator creator = new WPProjectGenerator(this.getProject(), null, "wp8");
            SubProgressMonitor generateMonitor = new SubProgressMonitor(monitor, 1);
            File vstudioProjectDir = creator.generateNow((IProgressMonitor)generateMonitor);
            monitor.worked(4);
            if (monitor.isCanceled()) {
                return;
            }
            this.doBuildProject(vstudioProjectDir, (IProgressMonitor)generateMonitor);
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.MSBuild_NoHybridError));
            }
            if (this.isRelease()) {
                this.setBuildArtifact(new File(this.getBuildDir(vstudioProjectDir), RELEASE_XAP_NAME));
            } else {
                this.setBuildArtifact(new File(this.getBuildDir(vstudioProjectDir), DEBUG_XAP_NAME));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public String getMSBuildPath() throws CoreException {
        File installationFile;
        String installationRoot = this.getInstallationRoot();
        if (installationRoot != null && (installationFile = new File(installationRoot)).exists()) {
            File[] versionFiles = installationFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("v");
                }
            });
            File highestVersion = null;
            File[] fileArray = versionFiles;
            int n = versionFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (highestVersion == null) {
                    highestVersion = file;
                } else {
                    Version current = Version.byName(highestVersion.getName());
                    Version newOne = Version.byName(file.getName());
                    if (newOne.compareTo(current) > 0) {
                        highestVersion = file;
                    }
                }
                ++n2;
            }
            if (highestVersion != null) {
                return new File(highestVersion.getAbsolutePath(), "MSBuild.exe").getAbsolutePath();
            }
        }
        return null;
    }

    private File getBuildDir(File vstudioProjectFolder) {
        File binFolder = new File(vstudioProjectFolder, "Bin");
        return new File(binFolder, this.isRelease() ? "Release" : "Debug");
    }

    private void doBuildProject(File projectLocation, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask(Messages.MSBuild_BuildProjectTask, 10);
            String msBuild = this.getMSBuildPath();
            if (msBuild != null) {
                File csprojFile = WPProjectUtils.getCsrojFile(projectLocation);
                Assert.isNotNull((Object)csprojFile);
                StringBuilder cmdString = new StringBuilder(this.addQuotes(msBuild));
                cmdString.append(" ");
                if (this.isRelease()) {
                    cmdString.append("/p:Configuration=Release ");
                }
                cmdString.append(this.addQuotes(csprojFile.getAbsolutePath()));
                ExternalProcessUtility processUtility = new ExternalProcessUtility();
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.worked(1);
                int ret = processUtility.execSync(cmdString.toString(), projectLocation, null, null, monitor, null, this.getLaunchConfiguration());
                if (ret != 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.MSBuild_MSBuildError));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private String getInstallationRoot() throws CoreException {
        return WindowsRegistry.readRegistry(DOT_NET, INSTALL_ROOT);
    }

    private String addQuotes(String path) {
        return "\"" + path + "\"";
    }
}

