/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.registry;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.BundleHttpCacheStorage;
import org.eclipse.thym.core.internal.util.HttpUtil;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.core.plugin.registry.PluginReceiver;

public class CordovaPluginRegistryManager {
    private static final String REGISTRY_URL = "http://registry.npmjs.org/";
    private final File cacheHome;
    private HashMap<String, CordovaRegistryPlugin> detailedPluginInfoCache = new HashMap();

    public CordovaPluginRegistryManager() {
        this.cacheHome = new File(FileUtils.getUserDirectory(), ".plugman" + File.separator + "cache");
    }

    public CordovaRegistryPlugin getCordovaPluginInfo(String name) throws CoreException {
        CordovaRegistryPlugin plugin = this.detailedPluginInfoCache.get(name);
        if (plugin != null) {
            return plugin;
        }
        DefaultHttpClient defHttpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(defHttpClient);
        CachingHttpClient client = new CachingHttpClient((HttpClient)defHttpClient, (ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)new BundleHttpCacheStorage(HybridCore.getContext().getBundle()), CordovaPluginRegistryManager.getCacheConfig());
        HttpGet get = new HttpGet(REGISTRY_URL + name);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
            plugin = new CordovaRegistryPlugin();
            this.readPluginInfo(reader, plugin);
            this.detailedPluginInfoCache.put(name, plugin);
            return plugin;
        }
        catch (ClientProtocolException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin information for " + name, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin information for " + name, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getInstallationDirectory(CordovaRegistryPlugin.RegistryPluginVersion plugin, IProgressMonitor monitor) {
        File pluginDir;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pluginDir = this.getFromCache(plugin)) != null) {
            return pluginDir;
        }
        File newCacheDir = this.calculateCacheDir(plugin);
        IRetrieveFileTransfer transfer = HybridCore.getDefault().getFileTransferService();
        try {
            IFileID remoteFileID = FileIDFactory.getDefault().createFileID(transfer.getRetrieveNamespace(), plugin.getTarball());
            Object lock = new Object();
            PluginReceiver receiver = new PluginReceiver(newCacheDir, monitor, lock);
            Object object = lock;
            synchronized (object) {
                transfer.sendRetrieveRequest(remoteFileID, (IFileTransferListener)receiver, null);
                lock.wait();
            }
        }
        catch (FileCreateException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        catch (IncomingFileTransferException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        catch (InterruptedException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        return new File(newCacheDir, "package");
    }

    private File getFromCache(CordovaRegistryPlugin.RegistryPluginVersion plugin) {
        File cachedPluginDir = this.calculateCacheDir(plugin);
        File packageDir = new File(cachedPluginDir, "package");
        if (!packageDir.isDirectory()) {
            return null;
        }
        File pluginxml = new File(packageDir, "plugin.xml");
        if (cachedPluginDir.isDirectory() && pluginxml.exists()) {
            return packageDir;
        }
        return null;
    }

    private File calculateCacheDir(CordovaRegistryPlugin.RegistryPluginVersion plugin) {
        File cachedPluginDir = new File(this.cacheHome, String.valueOf(plugin.getName()) + File.separator + plugin.getVersionNumber());
        return cachedPluginDir;
    }

    private static CacheConfig getCacheConfig() {
        CacheConfig config = new CacheConfig();
        config.setMaxObjectSize(122880L);
        return config;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CordovaRegistryPluginInfo> retrievePluginInfos(IProgressMonitor monitor) throws CoreException {
        ArrayList<CordovaRegistryPluginInfo> arrayList;
        JsonReader reader;
        block21: {
            CachingHttpClient client;
            block19: {
                block20: {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Retrieve plug-in registry catalog", 10);
                    DefaultHttpClient theHttpClient = new DefaultHttpClient();
                    HttpUtil.setupProxy(theHttpClient);
                    client = new CachingHttpClient((HttpClient)theHttpClient, (ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)new BundleHttpCacheStorage(HybridCore.getContext().getBundle()), CordovaPluginRegistryManager.getCacheConfig());
                    reader = null;
                    if (!monitor.isCanceled()) break block19;
                    if (reader == null) break block20;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
                return null;
            }
            String url = "http://registry.npmjs.org/-/_view/byKeyword?startkey=%5B%22ecosystem:cordova%22%5D&endkey=%5B%22ecosystem:cordova1%22%5D&group_level=3";
            HttpGet get = new HttpGet(URI.create(url));
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            monitor.worked(7);
            reader = new JsonReader((Reader)new InputStreamReader(stream));
            reader.beginObject();
            ArrayList<CordovaRegistryPluginInfo> plugins = new ArrayList<CordovaRegistryPluginInfo>();
            while (reader.hasNext()) {
                JsonToken token = reader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        reader.beginArray();
                        break;
                    }
                    case BEGIN_OBJECT: {
                        plugins.add(this.parseCordovaRegistryPluginInfo(reader));
                        break;
                    }
                    default: {
                        reader.skipValue();
                    }
                }
            }
            arrayList = plugins;
            if (reader == null) break block21;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        monitor.done();
        return arrayList;
        catch (ClientProtocolException e) {
            try {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin catalog", (Throwable)e));
                catch (IOException e2) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin catalog", (Throwable)e2));
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
                throw throwable;
            }
        }
    }

    private CordovaRegistryPluginInfo parseCordovaRegistryPluginInfo(JsonReader reader) throws IOException {
        CordovaRegistryPluginInfo info = new CordovaRegistryPluginInfo();
        reader.beginObject();
        reader.skipValue();
        reader.beginArray();
        reader.nextString();
        info.setName(this.safeReadStringValue(reader));
        info.setDescription(this.safeReadStringValue(reader));
        reader.endArray();
        reader.nextName();
        reader.nextInt();
        reader.endObject();
        return info;
    }

    private String safeReadStringValue(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.STRING) {
            return reader.nextString();
        }
        reader.skipValue();
        return "";
    }

    private void readVersionInfo(JsonReader reader, CordovaRegistryPlugin.RegistryPluginVersion version) throws IOException {
        Assert.isNotNull((Object)version);
        reader.beginObject();
        block3: while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case NAME: {
                    String name = reader.nextName();
                    if (!"dist".equals(name)) continue block3;
                    this.parseDistDetails(reader, version);
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
    }

    private void readPluginInfo(JsonReader reader, CordovaRegistryPlugin plugin) throws IOException {
        Assert.isNotNull((Object)plugin);
        reader.beginObject();
        block3: while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case NAME: {
                    String name = reader.nextName();
                    if ("name".equals(name)) {
                        plugin.setName(reader.nextString());
                        break;
                    }
                    if ("description".equals(name)) {
                        plugin.setDescription(reader.nextString());
                        break;
                    }
                    if ("keywords".equals(name)) {
                        this.parseKeywords(reader, plugin);
                        break;
                    }
                    if ("maintainers".equals(name)) {
                        this.parseMaintainers(reader, plugin);
                        break;
                    }
                    if ("dist-tags".equals(name)) {
                        this.parseLatestVersion(reader, plugin);
                        break;
                    }
                    if ("versions".equals(name) && plugin instanceof CordovaRegistryPlugin) {
                        this.parseVersions(reader, plugin);
                        break;
                    }
                    if (!"license".equals(name)) continue block3;
                    plugin.setLicense(reader.nextString());
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
    }

    private void parseDistDetails(JsonReader reader, CordovaRegistryPlugin.RegistryPluginVersion plugin) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case NAME: {
                    String name = reader.nextName();
                    if ("shasum".equals(name)) {
                        plugin.setShasum(reader.nextString());
                        break;
                    }
                    if (!"tarball".equals(name)) break;
                    plugin.setTarball(reader.nextString());
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
            token = reader.peek();
        }
        reader.endObject();
    }

    private void parseVersions(JsonReader reader, CordovaRegistryPlugin plugin) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case NAME: {
                    CordovaRegistryPlugin.RegistryPluginVersion version = plugin.new CordovaRegistryPlugin.RegistryPluginVersion();
                    version.setVersionNumber(reader.nextName());
                    this.readVersionInfo(reader, version);
                    plugin.addVersion(version);
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
            token = reader.peek();
        }
        reader.endObject();
    }

    private void parseLatestVersion(JsonReader reader, CordovaRegistryPlugin plugin) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case NAME: {
                    String tag = reader.nextName();
                    if (!"latest".equals(tag)) break;
                    plugin.setLatestVersion(reader.nextString());
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
            token = reader.peek();
        }
        reader.endObject();
    }

    private void parseMaintainers(JsonReader reader, CordovaRegistryPlugin plugin) throws IOException {
        reader.beginArray();
        String name = null;
        String email = null;
        JsonToken token = reader.peek();
        while (token != JsonToken.END_ARRAY) {
            switch (token) {
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    email = null;
                    name = null;
                    break;
                }
                case END_OBJECT: {
                    reader.endObject();
                    plugin.addMaintainer(email, name);
                    break;
                }
                case NAME: {
                    String tagName = reader.nextName();
                    if ("name".equals(tagName)) {
                        name = reader.nextString();
                        break;
                    }
                    if ("email".equals(tagName)) {
                        email = reader.nextString();
                        break;
                    }
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unexpected token");
                }
            }
            token = reader.peek();
        }
        reader.endArray();
    }

    private void parseKeywords(JsonReader reader, CordovaRegistryPlugin plugin) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            plugin.addKeyword(reader.nextString());
        }
        reader.endArray();
    }
}

