/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.AbstractEngineRepoProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.HttpUtil;

public class NpmBasedEngineRepoProvider
extends AbstractEngineRepoProvider {
    private static final String NPM_URL = "https://registry.npmjs.org/cordova-{0}";

    private InputStream getRemoteJSonStream(String url) throws IOException {
        try {
            SSLSocketFactory factory = new SSLSocketFactory(SSLContext.getDefault()){

                public Socket createSocket() throws IOException {
                    return SocketFactory.getDefault().createSocket();
                }

                public Socket createSocket(HttpParams params) throws IOException {
                    return SocketFactory.getDefault().createSocket();
                }
            };
            DefaultHttpClient client = new DefaultHttpClient();
            HttpUtil.setupProxy(client);
            client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)factory));
            HttpGet get = new HttpGet(url);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            return entity.getContent();
        }
        catch (NoSuchAlgorithmException e) {
            HybridCore.log(4, "Error creating the SSL Factory ", e);
            return null;
        }
    }

    @Override
    public List<DownloadableCordovaEngine> getEngines() throws CoreException {
        List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
        ArrayList<DownloadableCordovaEngine> allEngines = new ArrayList<DownloadableCordovaEngine>();
        for (PlatformSupport support : platforms) {
            List<DownloadableCordovaEngine> platEngines = this.getPlatformEngines(support.getPlatformId());
            if (platEngines == null || platEngines.isEmpty()) continue;
            allEngines.addAll(platEngines);
        }
        return allEngines;
    }

    private List<DownloadableCordovaEngine> getPlatformEngines(String platformId) throws CoreException {
        try {
            InputStream stream = this.getRemoteJSonStream(NLS.bind((String)NPM_URL, (Object)platformId));
            if (stream != null) {
                return this.parseEngines(stream, platformId);
            }
            return null;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Could not retrieve and parse downloadable platform information for ({0})", (Object)platformId), (Throwable)e));
        }
    }

    private List<DownloadableCordovaEngine> parseEngines(InputStream stream, String platformId) throws IOException {
        ArrayList<DownloadableCordovaEngine> engines = new ArrayList<DownloadableCordovaEngine>();
        try (JsonReader reader = null;){
            reader = new JsonReader((Reader)new InputStreamReader(stream));
            JsonParser parser = new JsonParser();
            JsonObject root = (JsonObject)parser.parse(reader);
            JsonElement element = root.get("versions");
            JsonObject topVersions = element.getAsJsonObject();
            Set versions = topVersions.entrySet();
            for (Map.Entry entry : versions) {
                JsonObject v = ((JsonElement)entry.getValue()).getAsJsonObject();
                DownloadableCordovaEngine engine = new DownloadableCordovaEngine();
                engine.setVersion(v.get("version").getAsString());
                engine.setPlatformId(platformId);
                JsonObject dist = v.get("dist").getAsJsonObject();
                engine.setDownloadURL(dist.get("tarball").getAsString());
                engines.add(engine);
            }
        }
        return engines;
    }
}

