/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.cordova;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.cordova.CordovaCLI;
import org.eclipse.thym.core.internal.cordova.ErrorDetectingCLIResult;
import org.eclipse.thym.ui.internal.cordova.MissingRequirementsDialog;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class RequirementsUtility {
    public static final String MIN_CORDOVA_VERSION = "5.2.0";

    private static int doCheckCordovaRequirements(HybridProject project) {
        ErrorDetectingCLIResult cordovaResult;
        block7: {
            IStatus cordovaStatus;
            CordovaCLI cli;
            block6: {
                try {
                    cli = CordovaCLI.newCLIforProject((HybridProject)project);
                    cordovaResult = (ErrorDetectingCLIResult)cli.version((IProgressMonitor)new NullProgressMonitor()).convertTo(ErrorDetectingCLIResult.class);
                    cordovaStatus = cordovaResult.asStatus();
                    if (!cordovaStatus.isOK()) break block6;
                    return 0;
                }
                catch (CoreException coreException) {
                    return 500;
                }
            }
            if (cordovaStatus.getCode() != 501) break block7;
            IStatus nodeStatus = ((ErrorDetectingCLIResult)cli.nodeVersion((IProgressMonitor)new NullProgressMonitor()).convertTo(ErrorDetectingCLIResult.class)).asStatus();
            if (nodeStatus.getCode() == 501) {
                return 503;
            }
            return 502;
        }
        Version cVer = Version.parseVersion((String)cordovaResult.getMessage());
        Version mVer = Version.parseVersion((String)MIN_CORDOVA_VERSION);
        if (cVer.compareTo(mVer) < 0) {
            return 504;
        }
        return 0;
    }

    public static boolean checkCordovaRequirements(HybridProject project) {
        int status = RequirementsUtility.doCheckCordovaRequirements(project);
        if (status > 0) {
            String message = null;
            switch (status) {
                case 502: {
                    message = "Cordova is missing on your system. Please refer to <a>instructions</a> on how to install Cordova";
                    break;
                }
                case 503: {
                    message = "Node.js and Cordova is missing on your system.  Please refer to <a>instructions</a> on how to install required software";
                    break;
                }
                default: {
                    message = "There are missing requirements on your system. Please refer to <a>instructions</a> on how to install required software";
                }
            }
            MissingRequirementsDialog mrd = new MissingRequirementsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            mrd.setMessage(message);
            mrd.open();
            return RequirementsUtility.doCheckCordovaRequirements(project) == 0;
        }
        return true;
    }
}

