/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import com.github.zafarkhaja.semver.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.internal.util.FileUtils;

public class AndroidLibraryResolver
extends HybridMobileLibraryResolver {
    private static final Version VERSION_4_0_0 = Version.valueOf((String)"4.0.0");
    public static final String DIR_LIBS = "libs";
    public static final String DIR_RES = "res";
    public static final String DIR_SRC = "src";
    public static final String FILE_JAR_CORDOVA = "cordova.jar";
    private static final IPath KEY_PATH_CORDOVA_JAR = new Path("libs/cordova.jar");
    public static final String FILE_XML_ANDROIDMANIFEST = "AndroidManifest.xml";
    HashMap<IPath, URL> files = new HashMap();

    private void initFiles() {
        Assert.isNotNull((Object)this.libraryRoot, (String)"Library resolver is not initialized. Call init before accessing any other functions.");
        if (this.version == null) {
            return;
        }
        Version ver = Version.valueOf((String)this.version);
        IPath templatePrjRoot = this.libraryRoot.append("bin/templates/project");
        IPath cordovaJar = this.libraryRoot.append("framework").append(NLS.bind((String)"cordova-{0}.jar", (Object)this.version));
        this.files.put(KEY_PATH_CORDOVA_JAR, this.getEngineFile(cordovaJar));
        this.files.put((IPath)new Path(DIR_RES), this.getEngineFile(templatePrjRoot.append(DIR_RES)));
        this.files.put((IPath)new Path(FILE_XML_ANDROIDMANIFEST), this.getEngineFile(templatePrjRoot.append(FILE_XML_ANDROIDMANIFEST)));
        this.files.put(new Path(DIR_SRC).append("$package".replace('.', '/')).append("$appname.java"), this.getEngineFile(templatePrjRoot.append("Activity.java")));
        if (ver.lessThan(VERSION_4_0_0)) {
            this.files.put(PATH_CORDOVA_JS, this.getEngineFile(this.libraryRoot.append("framework/assets/www/cordova.js")));
        } else {
            this.files.put(PATH_CORDOVA_JS, this.getEngineFile(templatePrjRoot.append("assets/www/cordova.js")));
        }
        this.files.put((IPath)new Path("framework/project.properties"), this.getEngineFile(this.libraryRoot.append("framework/project.properties")));
    }

    public URL getTemplateFile(IPath destination) {
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        Assert.isNotNull((Object)destination);
        Assert.isTrue((!destination.isAbsolute() ? 1 : 0) != 0);
        return this.files.get(destination);
    }

    public IStatus isLibraryConsistent() {
        if (this.version == null) {
            return new Status(4, "org.eclipse.thym.core", "Library for Android platform is not compatible with this tool. File for path {0} is missing.");
        }
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        for (IPath key : this.files.keySet()) {
            File file;
            URL url = this.files.get(key);
            if (url != null && ((file = new File(url.getFile())).exists() || key.equals((Object)KEY_PATH_CORDOVA_JAR))) continue;
            return new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Library for Android platform is not compatible with this tool. File for path {0} is missing.", (Object)key.toString()));
        }
        return Status.OK_STATUS;
    }

    public void preCompile(IProgressMonitor monitor) throws CoreException {
    }

    public boolean needsPreCompilation() {
        IPath cordovaJar = this.libraryRoot.append("framework").append(NLS.bind((String)"cordova-{0}.jar", (Object)this.version));
        return !cordovaJar.toFile().exists();
    }

    private URL getEngineFile(IPath path) {
        File file = path.toFile();
        if (!file.exists()) {
            AndroidCore.log(2, NLS.bind((String)"Missing Android engine file {0}", (Object)file.toString()), null);
        }
        return FileUtils.toURL((File)file);
    }

    public String detectVersion() {
        File versionFile = this.libraryRoot.append("VERSION").toFile();
        if (versionFile.exists()) {
            String string;
            block8: {
                BufferedReader reader = null;
                try {
                    String version;
                    reader = new BufferedReader(new FileReader(versionFile));
                    string = version = reader.readLine();
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        AndroidCore.log(2, "Can not detect version on library", e);
                    }
                }
                reader.close();
            }
            return string;
        } else {
            AndroidCore.log(2, NLS.bind((String)"Can not detect version. VERSION file {0} is missing", (Object)versionFile.toString()), null);
        }
        return null;
    }
}

