/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngineLocator;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.extensions.CordovaEngineRepoProvider;
import org.eclipse.thym.core.extensions.ExtensionPointProxy;
import org.eclipse.thym.core.extensions.NativeProjectBuilder;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class HybridCore
implements BundleActivator,
DebugOptionsListener {
    public static final String PLUGIN_ID = "org.eclipse.thym.core";
    private static BundleContext context;
    public static boolean DEBUG;
    private static DebugTrace TRACE;
    private static ILog logger;
    private ServiceTracker<IRetrieveFileTransferFactory, IRetrieveFileTransferFactory> retrievalFactoryTracker;
    private static HybridCore inst;

    public HybridCore() {
        inst = this;
    }

    public static HybridCore getDefault() {
        return inst;
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logger = Platform.getLog((Bundle)HybridCore.getContext().getBundle());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.retrievalFactoryTracker != null) {
            this.retrievalFactoryTracker.close();
        }
        WidgetModel.shutdown();
        context = null;
    }

    public IRetrieveFileTransfer getFileTransferService() {
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)this.getFileTransferServiceTracker().getService();
        return factory.newInstance();
    }

    public IProxyService getProxyService() {
        ServiceReference sr = context.getServiceReference(IProxyService.class);
        return (IProxyService)context.getService(sr);
    }

    private synchronized ServiceTracker<IRetrieveFileTransferFactory, IRetrieveFileTransferFactory> getFileTransferServiceTracker() {
        if (this.retrievalFactoryTracker == null) {
            this.retrievalFactoryTracker = new ServiceTracker(HybridCore.getContext(), IRetrieveFileTransferFactory.class, null);
            this.retrievalFactoryTracker.open();
            this.startBundle("org.eclipse.ecf");
            this.startBundle("org.eclipse.ecf.provider.filetransfer");
        }
        return this.retrievalFactoryTracker;
    }

    private boolean startBundle(String bundleId) {
        ServiceTracker packageAdminTracker = new ServiceTracker(HybridCore.getContext(), PackageAdmin.class.getName(), null);
        packageAdminTracker.open();
        PackageAdmin packageAdmin = (PackageAdmin)packageAdminTracker.getService();
        if (packageAdmin == null) {
            return false;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleId, null);
        if (bundles != null && bundles.length > 0) {
            int i = 0;
            while (i < bundles.length) {
                try {
                    if ((bundles[i].getState() & 2) == 0) {
                        bundles[i].start(2);
                        bundles[i].start(1);
                        return true;
                    }
                }
                catch (BundleException bundleException) {}
                ++i;
            }
        }
        return false;
    }

    public static List<HybridProject> getHybridProjects() {
        IProject[] projects;
        ArrayList<HybridProject> hybrids = new ArrayList<HybridProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            HybridProject hybridProject = HybridProject.getHybridProject(project);
            if (hybridProject != null) {
                hybrids.add(hybridProject);
            }
            ++n2;
        }
        return hybrids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsChanged(DebugOptions options) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (TRACE == null) {
                TRACE = options.newDebugTrace(PLUGIN_ID);
            }
            DEBUG = options.getBooleanOption("org.eclipse.thym.core/debug", true);
        }
    }

    public static void trace(String message) {
        if (!DEBUG) {
            return;
        }
        TRACE.trace(null, message);
    }

    public static void log(int status, String message, Throwable throwable) {
        logger.log((IStatus)new Status(status, PLUGIN_ID, message, throwable));
    }

    public static List<PlatformSupport> getPlatformSupports() {
        return ExtensionPointProxy.getNativeExtensionPointProxy("org.eclipse.thym.core.platformSupport", PlatformSupport.class);
    }

    public static PlatformSupport getPlatformSupport(String platformID) {
        List<PlatformSupport> generators = HybridCore.getPlatformSupports();
        for (PlatformSupport projectGenerator : generators) {
            if (!projectGenerator.getPlatformId().equals(platformID)) continue;
            return projectGenerator;
        }
        return null;
    }

    public static List<NativeProjectBuilder> getNativeProjectBuilders() {
        return ExtensionPointProxy.getNativeExtensionPointProxy("org.eclipse.thym.core.projectBuilder", NativeProjectBuilder.class);
    }

    public static List<CordovaEngineRepoProvider> getCordovaEngineRepoProviders() {
        return ExtensionPointProxy.getNativeExtensionPointProxy("org.eclipse.thym.core.cordovaEngineRepoProvider", CordovaEngineRepoProvider.class);
    }

    public static List<HybridMobileEngineLocator> getEngineLocators() {
        ArrayList<HybridMobileEngineLocator> locators = new ArrayList<HybridMobileEngineLocator>();
        locators.add(new CordovaEngineProvider());
        return locators;
    }

    public String[] getCustomLibraryLocations() {
        String s = Platform.getPreferencesService().getString("org.eclipse.thym.ui", "custom_engine_loc", null, null);
        if (s == null || s.length() < 1) {
            return new String[0];
        }
        return s.split(",");
    }
}

