/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.cordova;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.cordova.CordovaCLIResult;
import org.eclipse.thym.core.internal.cordova.CordovaCLIStreamListener;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;

public class CordovaCLI {
    public static final String OPTION_SAVE = "--save";
    private static final String P_COMMAND_PLUGIN = "plugin";
    private static final String P_COMMAND_PLATFORM = "platform";
    private static final String P_COMMAND_PREPARE = "prepare";
    private static final String P_COMMAND_EMULATE = "run --emulator";
    private static final String P_COMMAND_RUN = "run";
    private static final String P_COMMAND_BUILD = "build";
    private static Map<String, Lock> projectLock = Collections.synchronizedMap(new HashMap());
    private HybridProject project;

    public static CordovaCLI newCLIforProject(HybridProject project) {
        if (project == null) {
            throw new IllegalArgumentException("No project specified");
        }
        return new CordovaCLI(project);
    }

    private CordovaCLI(HybridProject project) {
        this.project = project;
    }

    public CordovaCLIResult build(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova build"));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_BUILD, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult prepare(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova prepare "));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_PREPARE, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult emulate(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova run --emulator"));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_EMULATE, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult run(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova run"));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_RUN, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult platform(Command command, IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova platform " + command.getCliCommand()));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_PLATFORM, command, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult plugin(Command command, IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova plugin " + command.getCliCommand()));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_PLUGIN, command, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult version(IProgressMonitor monitor) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova -version"));
        String cordovaCommand = this.generateCordovaCommand(null, null, "-version");
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult nodeVersion(IProgressMonitor monitor) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("node -v"));
        String command = "node -v\n";
        this.sendCordovaCommand(process, command, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    private void sendCordovaCommand(IProcess process, String cordovaCommand, IProgressMonitor monitor) throws CoreException {
        Lock lock = this.projectLock();
        lock.lock();
        try {
            try {
                IStreamsProxy streamProxy = process.getStreamsProxy();
                streamProxy.write(cordovaCommand.toString());
                while (!process.isTerminated()) {
                    streamProxy.write("exit\n");
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Fatal error invoking cordova CLI", (Throwable)e));
            }
            catch (InterruptedException e) {
                HybridCore.log(1, "Exception waiting for process to terminate", e);
                lock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private String generateCordovaCommand(String command, Command subCommand, String ... options) {
        StringBuilder builder = new StringBuilder();
        builder.append("cordova");
        if (command != null) {
            builder.append(" ");
            builder.append(command);
        }
        if (subCommand != null) {
            builder.append(" ");
            builder.append(subCommand.getCliCommand());
        }
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!string.isEmpty()) {
                builder.append(" ");
                builder.append(string);
            }
            ++n2;
        }
        builder.append("\n");
        return builder.toString();
    }

    public IProcess startShell(IStreamListener listener, IProgressMonitor monitor, ILaunchConfiguration launchConfiguration) throws CoreException {
        ArrayList<String> commandList = new ArrayList<String>();
        if (this.isWindows()) {
            commandList.add("cmd");
        } else {
            commandList.add("/bin/bash");
            commandList.add("-l");
        }
        ExternalProcessUtility ep = new ExternalProcessUtility();
        IProcess process = ep.exec(commandList.toArray(new String[commandList.size()]), this.getWorkingDirectory(), monitor, null, launchConfiguration);
        if (listener != null) {
            process.getStreamsProxy().getOutputStreamMonitor().addListener(listener);
            process.getStreamsProxy().getErrorStreamMonitor().addListener(listener);
        }
        return process;
    }

    private boolean isWindows() {
        String OS = System.getProperty("os.name", "unknown");
        return OS.toLowerCase().indexOf("win") > -1;
    }

    private ILaunchConfiguration getLaunchConfiguration(String label) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            ILaunchConfigurationWorkingCopy cfg = type.newInstance(null, "cordova");
            ILaunchConfigurationWorkingCopy wc = cfg.getWorkingCopy();
            wc.setAttribute(IProcess.ATTR_PROCESS_LABEL, label);
            cfg = wc.doSave();
            return cfg;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Lock projectLock() {
        String projectName = this.project.getProject().getName();
        Lock l = projectLock.get(this.project.getProject().getName());
        if (l == null) {
            l = new ReentrantLock();
            projectLock.put(projectName, l);
        }
        return l;
    }

    private File getWorkingDirectory() {
        IPath wp = this.project.getProject().getLocation();
        if (wp == null) {
            return null;
        }
        return wp.toFile();
    }

    public static enum Command {
        ADD("add"),
        REMOVE("remove");

        private final String cliCommand;

        private Command(String cli) {
            this.cliCommand = cli;
        }

        public String getCliCommand() {
            return this.cliCommand;
        }
    }
}

