/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.cordova.CordovaCLI;
import org.eclipse.thym.core.internal.cordova.ErrorDetectingCLIResult;
import org.eclipse.thym.ui.HybridUI;

public class RestoreProjectListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta[] iResourceDeltaArray = projectDeltas = event.getDelta().getAffectedChildren();
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (delta.getKind() == 1 && (delta.getFlags() & 0x4000) != 0 && delta.getResource().getType() == 4) {
                IProject project = delta.getResource().getProject();
                try {
                    if (project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
                        RestoreProjectJob job = new RestoreProjectJob(project);
                        job.schedule();
                    }
                }
                catch (CoreException e) {
                    HybridUI.log(4, NLS.bind((String)"Can not check nature for project {0} ", (Object)project.getName()), e);
                }
            }
            ++n2;
        }
    }

    private class RestoreProjectJob
    extends Job {
        private IProject project;

        public RestoreProjectJob(IProject project) {
            super("Prepare cordova project job");
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.project);
            if (hybridProject == null) {
                return Status.OK_STATUS;
            }
            IStatus status = Status.OK_STATUS;
            try {
                status = ((ErrorDetectingCLIResult)CordovaCLI.newCLIforProject((HybridProject)hybridProject).prepare(monitor, new String[]{""}).convertTo(ErrorDetectingCLIResult.class)).asStatus();
                hybridProject.getProject().refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return status;
        }
    }
}

