/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.win.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.cordova.CordovaCLI;
import org.eclipse.thym.win.core.build.WinBuild;
import org.eclipse.thym.win.internal.core.Messages;

public class WinLaunchDelegate
implements ILaunchConfigurationDelegate2 {
    private static String EMULATE_ARGS = "windows --archs=\"x86\" -- -phone";
    private static String SIM_ARGS = "windows --archs=\"x86\" -- -win";
    private static String RUN_ARGS = "windows --device --archs=\"arm\" -- -phone";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.WinLaunchDelegate_LaunchEmulator, 10);
        IProject kernelProject = this.getProject(configuration);
        Assert.isNotNull((Object)kernelProject, (String)Messages.WinLaunchDelegate_NoProjectError);
        HybridProject project = HybridProject.getHybridProject((IProject)kernelProject);
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.win.core", NLS.bind((String)Messages.WinLaunchDelegate_NotHybridError, (Object)kernelProject.getName())));
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String launchType = configuration.getAttribute("org.eclipse.thym.win.core.ATTR_LAUNCH_TYPE_EMULATOR", null);
        if (launchType.equals("ATTR_LAUNCH_TYPE_EMULATOR")) {
            CordovaCLI.newCLIforProject((HybridProject)project).emulate((IProgressMonitor)sm.newChild(90), new String[]{EMULATE_ARGS});
        } else if (launchType.equals("ATTR_LAUNCH_TYPE_SIMULATOR")) {
            CordovaCLI.newCLIforProject((HybridProject)project).emulate((IProgressMonitor)sm.newChild(90), new String[]{SIM_ARGS});
        } else if (launchType.equals("ATTR_LAUNCH_TYPE_DEVICE")) {
            CordovaCLI.newCLIforProject((HybridProject)project).run((IProgressMonitor)sm.newChild(90), new String[]{RUN_ARGS});
        }
        sm.worked(30);
        monitor.worked(2);
        monitor.done();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        WinBuild build = new WinBuild();
        build.init(this.getProject(configuration), null);
        build.buildNow(monitor);
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.done();
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return true;
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
            if (projectName != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }
}

