/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.extensions;

import java.io.File;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.extensions.ExtensionPointProxy;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;

public class NativeProjectBuilder
extends ExtensionPointProxy {
    public static final String EXTENSION_POINT_ID = "org.eclipse.thym.core.projectBuilder";
    public static final String ATTR_PLATFORM = "platform";
    public static final String ATTR_DELEGATE = "delegate";
    public static final String ATTR_ID = "id";
    private String id;
    private String platform;
    private Expression expression;

    NativeProjectBuilder(IConfigurationElement element) {
        super(element);
        this.id = element.getAttribute(ATTR_ID);
        this.platform = element.getAttribute(ATTR_PLATFORM);
        this.configureEnablement(element.getChildren("enablement"));
    }

    private void configureEnablement(IConfigurationElement[] enablementNodes) {
        if (enablementNodes == null || enablementNodes.length < 1) {
            return;
        }
        IConfigurationElement node = enablementNodes[0];
        try {
            this.expression = ExpressionConverter.getDefault().perform(node);
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error while reading the enablement", e);
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getID() {
        return this.id;
    }

    public boolean isEnabled(IEvaluationContext context) throws CoreException {
        if (this.expression == null) {
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("Must have an evalutation context");
        }
        return this.expression.evaluate(context) == EvaluationResult.TRUE;
    }

    public AbstractNativeBinaryBuildDelegate createDelegate(IProject project, File destination) throws CoreException {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensions(this.contributor);
        if (extensions == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Contributing platform is no longer available."));
        }
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getExtensionPointUniqueIdentifier().equals(EXTENSION_POINT_ID)) {
                IConfigurationElement[] configs = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    if (configs[j].getAttribute(ATTR_PLATFORM).equals(this.getPlatform())) {
                        AbstractNativeBinaryBuildDelegate delegate = (AbstractNativeBinaryBuildDelegate)configs[j].createExecutableExtension(ATTR_DELEGATE);
                        delegate.init(project, destination);
                        return delegate;
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Contributing platform has changed"));
    }
}

