/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.thym.core.CordovaEnvVariables;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class AndroidCore
implements BundleActivator,
DebugOptionsListener,
CordovaEnvVariables {
    public static final String PLUGIN_ID = "org.eclipse.thym.android.core";
    private static BundleContext context;
    private static ILog logger;
    public static boolean DEBUG;
    private static DebugTrace TRACE;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        AndroidCore.context = context;
        logger = Platform.getLog((Bundle)AndroidCore.getContext().getBundle());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void stop(BundleContext context) throws Exception {
        AndroidCore.context = null;
    }

    public static String getSDKLocation() {
        String prefSDKLocation = Platform.getPreferencesService().getString("org.eclipse.thym.ui", "Android_SDK_Loc", null, null);
        if (AndroidCore.isValidSDKLocation(prefSDKLocation)) {
            return prefSDKLocation;
        }
        String envSDKLocation = System.getenv("ANDROID_HOME");
        if (AndroidCore.isValidSDKLocation(envSDKLocation)) {
            return envSDKLocation;
        }
        return null;
    }

    private static boolean isValidSDKLocation(String sdkLocation) {
        if (sdkLocation != null && !sdkLocation.isEmpty()) {
            File file = new File(sdkLocation);
            if (!file.isDirectory()) {
                return false;
            }
            File toolsFolder = new File(file, "tools");
            File platformToolsFolder = new File(file, "platform-tools");
            return toolsFolder.isDirectory() && platformToolsFolder.isDirectory();
        }
        return false;
    }

    public static void log(int status, String message, Throwable throwable) {
        logger.log((IStatus)new Status(status, PLUGIN_ID, message, throwable));
    }

    public void optionsChanged(DebugOptions options) {
        if (TRACE == null) {
            TRACE = options.newDebugTrace(PLUGIN_ID);
        }
        DEBUG = options.getBooleanOption("org.eclipse.thym.android.core/debug", true);
    }

    public static void trace(String message) {
        if (!DEBUG) {
            return;
        }
        TRACE.trace(null, message);
    }

    public Map<String, String> getAdditionalEnvVariables() {
        HashMap<String, String> sdkEnv = new HashMap<String, String>();
        String sdkLocation = AndroidCore.getSDKLocation();
        if (sdkLocation != null) {
            sdkEnv.put("ANDROID_HOME", sdkLocation);
        }
        return sdkEnv;
    }
}

