/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.android.core.adt.AndroidAPILevelComparator;
import org.eclipse.thym.android.core.adt.AndroidAVD;
import org.eclipse.thym.android.core.adt.AndroidDevice;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.android.core.adt.BuildDelegate;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;

public class AndroidLaunchDelegate
implements ILaunchConfigurationDelegate2 {
    private File artifact;
    private AndroidDevice device;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (this.device == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Failed to connect with the device or emulator. We will attempt to reconnect, please try running your application again."));
        }
        AndroidSDKManager sdk = AndroidSDKManager.getManager();
        HybridProject project = HybridProject.getHybridProject((IProject)this.getProject(configuration));
        WidgetModel model = WidgetModel.getModel((HybridProject)project);
        Widget widget = model.getWidgetForRead();
        String packageName = widget.getId();
        String name = "MainActivity";
        sdk.installApk(this.artifact, this.device.getSerialNumber(), monitor);
        sdk.startApp(String.valueOf(packageName) + "/." + name, this.device.getSerialNumber(), monitor);
        String logcatFilter = configuration.getAttribute("org.eclipse.thym.android.core.ATTR_LOGCAT_FILTER", "Cordova:V DroidGap:V CordovaLog:V CordovaPlugin:V CordovaChromeClient:V CordovaWebView:V *:S");
        sdk.logcat(logcatFilter, null, null, this.device.getSerialNumber());
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return false;
        }
        BuildDelegate buildDelegate = new BuildDelegate();
        buildDelegate.init(this.getProject(configuration), null);
        buildDelegate.buildNow(monitor);
        this.artifact = buildDelegate.getBuildArtifact();
        return true;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.done();
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean runOnDevice = configuration.getAttribute("org.eclipse.thym.android.core.ATTR_IS_DEVICE_LAUNCH", false);
        AndroidSDKManager sdk = AndroidSDKManager.getManager();
        if (!runOnDevice) {
            sdk.killADBServer();
        }
        sdk.startADBServer();
        if (runOnDevice) {
            String serial = configuration.getAttribute("org.eclipse.thym.android.core.ATTR_DEVICE_SERIAL", null);
            Assert.isNotNull((Object)serial);
            List<AndroidDevice> devices = sdk.listDevices();
            for (AndroidDevice androidDevice : devices) {
                if (!androidDevice.isEmulator()) {
                    this.device = androidDevice;
                }
                if (!serial.equals(androidDevice.getSerialNumber())) continue;
                this.device = androidDevice;
                break;
            }
            if (this.device != null) {
                monitor.done();
                return true;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Could not establish connection with the device. Please try again."));
        }
        AndroidDevice emulator = this.getEmulator();
        if (emulator == null) {
            String avdName = this.selectAVD(configuration, sdk);
            if (monitor.isCanceled()) {
                return false;
            }
            IProcess emulatorProcess = sdk.startEmulator(avdName);
            sdk.waitForEmulator(emulatorProcess, monitor);
        }
        this.device = this.getEmulator();
        if (this.device == null) {
            sdk.killADBServer();
            sdk.startADBServer();
            this.device = this.getEmulator();
        }
        monitor.done();
        return true;
    }

    private String selectAVD(ILaunchConfiguration configuration, AndroidSDKManager sdk) throws CoreException {
        List<AndroidAVD> avds = sdk.listAVDs();
        if (avds == null || avds.isEmpty()) {
            throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.android.core", 210, "No Android AVDs are available", null));
        }
        String avdName = configuration.getAttribute("org.eclipse.thym.android.core.ATTR_AVD_NAME", null);
        AndroidAPILevelComparator alc = new AndroidAPILevelComparator();
        for (AndroidAVD androidAVD : avds) {
            if (avdName == null) {
                if (alc.compare(androidAVD.getApiLevel(), "17") <= -1) continue;
                avdName = androidAVD.getName();
                break;
            }
            if (!androidAVD.getName().equals(avdName) || alc.compare(androidAVD.getApiLevel(), "17") >= 0) continue;
            throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.android.core", 210, NLS.bind((String)"Selected Android AVD {0} does not satisfy the satisfy the minimum API level({1})", (Object[])new String[]{avdName, "17"}), null));
        }
        if (avdName == null) {
            throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.android.core", 210, NLS.bind((String)"Defined Android AVDs do not satisfy the minimum API level({0})", (Object)"17"), null));
        }
        return avdName;
    }

    private AndroidDevice getEmulator() throws CoreException {
        AndroidSDKManager sdk = AndroidSDKManager.getManager();
        List<AndroidDevice> devices = sdk.listDevices();
        for (AndroidDevice androidDevice : devices) {
            if (!androidDevice.isEmulator() || androidDevice.getState() != 2) continue;
            return androidDevice;
        }
        return null;
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
            if (projectName != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }
}

