/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.android.core.adt.AndroidAPILevelComparator;
import org.eclipse.thym.android.core.adt.AndroidAVD;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.android.ui.SDKLocationHelper;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AndroidSimOptionsTab
extends AbstractLaunchConfigurationTab {
    private Text textProject;
    private Text logFilterTxt;
    private Listener dirtyListener = new DirtyListener();
    private Combo AVDCombo;
    private List<AndroidAVD> avds;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group grpProject = new Group(comp, 0);
        grpProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpProject.setText("Project");
        grpProject.setLayout((Layout)new GridLayout(3, false));
        Label lblProject = new Label((Composite)grpProject, 0);
        lblProject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProject.setText("Project:");
        this.textProject = new Text((Composite)grpProject, 2048);
        this.textProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textProject.addListener(24, this.dirtyListener);
        Button btnProjectBrowse = new Button((Composite)grpProject, 0);
        btnProjectBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog es = new ElementListSelectionDialog(AndroidSimOptionsTab.this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                es.setTitle("Project Selection");
                es.setMessage("Select a project to run");
                es.setElements(HybridCore.getHybridProjects().toArray());
                if (es.open() == 0) {
                    HybridProject project = (HybridProject)es.getFirstResult();
                    AndroidSimOptionsTab.this.textProject.setText(project.getProject().getName());
                }
            }
        });
        btnProjectBrowse.setText("Browse...");
        Group grpEmulator = new Group(comp, 0);
        grpEmulator.setLayout((Layout)new GridLayout(2, false));
        grpEmulator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpEmulator.setText("Emulator");
        Label lblVirtualDeviceavd = new Label((Composite)grpEmulator, 0);
        lblVirtualDeviceavd.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVirtualDeviceavd.setText("Virtual Device (AVD):");
        this.AVDCombo = new Combo((Composite)grpEmulator, 8);
        this.AVDCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.AVDCombo.add("", 0);
        this.AVDCombo.addListener(13, this.dirtyListener);
        Label lblLogFilter = new Label((Composite)grpEmulator, 0);
        lblLogFilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLogFilter.setText("Log Filter:");
        this.logFilterTxt = new Text((Composite)grpEmulator, 2048);
        this.logFilterTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.logFilterTxt.addListener(24, this.dirtyListener);
        try {
            AndroidSDKManager sdk = AndroidSDKManager.getManager();
            this.avds = sdk.listAVDs();
            for (AndroidAVD avd : this.avds) {
                this.AVDCombo.add(avd.getName());
            }
        }
        catch (CoreException coreException) {
            this.AVDCombo.removeAll();
        }
    }

    public String getName() {
        return "Emulator";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (!SDKLocationHelper.defineSDKLocationIfNecessary()) {
            this.setErrorMessage("Android SDK location is not defined");
        }
        String projectName = null;
        try {
            projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
        }
        catch (CoreException coreException) {}
        if (projectName != null) {
            this.textProject.setText(projectName);
        }
        try {
            String filter = configuration.getAttribute("org.eclipse.thym.android.core.ATTR_LOGCAT_FILTER", "Cordova:V DroidGap:V CordovaLog:V CordovaPlugin:V CordovaChromeClient:V CordovaWebView:V *:S");
            this.logFilterTxt.setText(filter);
        }
        catch (CoreException coreException) {
            this.logFilterTxt.setText("");
        }
        try {
            String avd = configuration.getAttribute("org.eclipse.thym.android.core.ATTR_AVD_NAME", "");
            int index = this.AVDCombo.indexOf(avd);
            if (index < 0) {
                index = 0;
            }
            this.AVDCombo.select(index);
        }
        catch (CoreException coreException) {}
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", this.textProject.getText());
        String avd = this.AVDCombo.getText();
        if (avd != null && avd.isEmpty()) {
            avd = null;
        }
        configuration.setAttribute("org.eclipse.thym.android.core.ATTR_AVD_NAME", avd);
        configuration.setAttribute("org.eclipse.thym.android.core.ATTR_LOGCAT_FILTER", this.logFilterTxt.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
        configuration.setAttribute("org.eclipse.thym.android.core.ATTR_LOGCAT_FILTER", "Cordova:V DroidGap:V CordovaLog:V CordovaPlugin:V CordovaChromeClient:V CordovaWebView:V *:S");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.isTabValid() && AndroidCore.getSDKLocation() != null && super.isValid(launchConfig);
    }

    private boolean isTabValid() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (AndroidCore.getSDKLocation() == null) {
            this.setErrorMessage("Android SDK location is not defined");
            return false;
        }
        String avd = this.AVDCombo.getText();
        if (avd != null && !avd.isEmpty()) {
            AndroidAPILevelComparator alc = new AndroidAPILevelComparator();
            for (AndroidAVD androidAVD : this.avds) {
                if (!androidAVD.getName().equals(avd) || alc.compare(androidAVD.getApiLevel(), "17") >= 0) continue;
                this.setErrorMessage("Selected AVD does not satisfy the minimum required API level. Please select a different one");
                return false;
            }
        }
        return true;
    }

    public boolean canSave() {
        return this.isTabValid();
    }

    private class DirtyListener
    implements Listener {
        private DirtyListener() {
        }

        public void handleEvent(Event event) {
            AndroidSimOptionsTab.this.setDirty(true);
            AndroidSimOptionsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

