/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.config.AbstractConfigObject;
import org.eclipse.thym.core.config.Access;
import org.eclipse.thym.core.config.Author;
import org.eclipse.thym.core.config.Content;
import org.eclipse.thym.core.config.Engine;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Icon;
import org.eclipse.thym.core.config.License;
import org.eclipse.thym.core.config.Plugin;
import org.eclipse.thym.core.config.Preference;
import org.eclipse.thym.core.config.Splash;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Widget
extends AbstractConfigObject {
    private AbstractConfigObject.Property<String> id = new AbstractConfigObject.Property("id");
    private AbstractConfigObject.Property<String> version = new AbstractConfigObject.Property("version");
    private AbstractConfigObject.Property<String> name = new AbstractConfigObject.Property("name");
    private AbstractConfigObject.Property<String> shortname = new AbstractConfigObject.Property("shortname");
    private AbstractConfigObject.Property<String> description = new AbstractConfigObject.Property("description");
    private AbstractConfigObject.Property<String> viewmodes = new AbstractConfigObject.Property("viewmodes");
    private AbstractConfigObject.Property<Author> author = new AbstractConfigObject.Property("author");
    private AbstractConfigObject.Property<Content> content = new AbstractConfigObject.Property("content");
    private AbstractConfigObject.Property<License> license = new AbstractConfigObject.Property("license");
    private AbstractConfigObject.Property<List<Preference>> preferences = new AbstractConfigObject.Property("preferences");
    private AbstractConfigObject.Property<List<Access>> accesses = new AbstractConfigObject.Property("accesses");
    private AbstractConfigObject.Property<List<Feature>> features = new AbstractConfigObject.Property("features");
    private AbstractConfigObject.Property<List<Icon>> icons = new AbstractConfigObject.Property("icons");
    private AbstractConfigObject.Property<List<Splash>> splashes = new AbstractConfigObject.Property("splashes");
    private AbstractConfigObject.Property<List<Engine>> engines = new AbstractConfigObject.Property("engines");
    private AbstractConfigObject.Property<List<Plugin>> plugins = new AbstractConfigObject.Property("plugins");

    Widget(Node node) {
        this.init(node);
    }

    void reload(Node node) {
        this.init(node);
    }

    private void init(Node node) {
        this.itemNode = (Element)node;
        this.id.setValue(this.getNodeAttribute(node, null, "id"));
        this.version.setValue(this.getNodeAttribute(node, null, "version"));
        this.loadName(node);
        this.loadDescription(node);
        this.loadItem("author", null, node, this.author, Author.class);
        this.loadItem("content", null, node, this.content, Content.class);
        this.loadItem("license", null, node, this.license, License.class);
        this.loadListItem("preference", null, node, this.preferences, Preference.class);
        this.loadListItem("access", null, node, this.accesses, Access.class);
        this.loadListItem("feature", null, node, this.features, Feature.class);
        this.loadListItem("icon", null, node, this.icons, Icon.class);
        this.loadListItem("splash", null, node, this.splashes, Splash.class);
        this.loadListItem("engine", null, node, this.engines, Engine.class);
        this.loadListItem("plugin", null, node, this.plugins, Plugin.class);
    }

    private <T extends AbstractConfigObject> void loadItem(String tagName, String namespace, Node node, AbstractConfigObject.Property<T> prop, Class<T> clazz) {
        Element el = (Element)node;
        NodeList nodes = el.getElementsByTagNameNS(namespace, tagName);
        if (nodes.getLength() > 0) {
            try {
                prop.setValue((AbstractConfigObject)clazz.getDeclaredConstructor(Node.class).newInstance(nodes.item(0)));
            }
            catch (Exception e) {
                HybridCore.log(4, "Error invoking the Node constructor for config model object", e);
            }
        } else {
            prop.setValue(null);
        }
    }

    private void loadDescription(Node node) {
        this.description.setValue(this.getTextContentForTag(node, "description"));
    }

    private void loadName(Node node) {
        this.name.setValue(this.getTextContentForTag(node, "name"));
        NodeList nodes = this.itemNode.getElementsByTagNameNS("http://www.w3.org/ns/widgets", "name");
        if (nodes.getLength() > 0) {
            this.shortname.setValue(this.getNodeAttribute(nodes.item(0), null, "short"));
        } else {
            this.shortname.setValue(null);
        }
    }

    private <T extends AbstractConfigObject> void loadListItem(String tagName, String namespaceURI, Node node, AbstractConfigObject.Property<List<T>> props, Class<T> clazz) {
        ArrayList<AbstractConfigObject> items = null;
        Element el = (Element)node;
        NodeList nodes = null;
        nodes = namespaceURI != null ? el.getElementsByTagNameNS(namespaceURI, tagName) : el.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            items = new ArrayList<AbstractConfigObject>();
            int i = 0;
            while (i < nodes.getLength()) {
                try {
                    AbstractConfigObject item = (AbstractConfigObject)clazz.getDeclaredConstructor(Node.class).newInstance(nodes.item(i));
                    items.add(item);
                }
                catch (Exception e) {
                    HybridCore.log(4, "Error invoking the Node constructor for config model object", e);
                }
                ++i;
            }
        }
        props.setValue(items);
    }

    public String getId() {
        return this.id.getValue();
    }

    public String getVersion() {
        return this.version.getValue();
    }

    public String getName() {
        return this.name.getValue();
    }

    public String getShortname() {
        return this.shortname.getValue();
    }

    public String getDescription() {
        return this.description.getValue();
    }

    public String getViewmodes() {
        return this.viewmodes.getValue();
    }

    public Author getAuthor() {
        return this.author.getValue();
    }

    public Content getContent() {
        return this.content.getValue();
    }

    public License getLicense() {
        return this.license.getValue();
    }

    public List<Preference> getPreferences() {
        return this.preferences.getValue();
    }

    public List<Access> getAccesses() {
        return this.accesses.getValue();
    }

    public List<Feature> getFeatures() {
        return this.features.getValue();
    }

    public List<Icon> getIcons() {
        return this.icons.getValue();
    }

    public List<Splash> getSplashes() {
        return this.splashes.getValue();
    }

    public List<Engine> getEngines() {
        return this.engines.getValue();
    }

    public List<Plugin> getPlugins() {
        return this.plugins.getValue();
    }

    public void setId(String id) {
        this.id.setValue(id);
        this.setAttributeValue(this.itemNode, null, "id", id);
    }

    public void setVersion(String version) {
        this.version.setValue(version);
        this.setAttributeValue(this.itemNode, null, "version", version);
    }

    public void setName(String name) {
        this.name.setValue(name);
        this.setTextContentValueForTag(this.itemNode, null, "name", name);
    }

    public void setShortname(String shortname) {
        this.shortname.setValue(shortname);
        NodeList nodes = this.itemNode.getElementsByTagNameNS(null, "name");
        if (nodes.getLength() > 0) {
            this.setAttributeValue((Element)nodes.item(0), null, "short", shortname);
        }
    }

    public void setDescription(String description) {
        this.description.setValue(description);
        this.setTextContentValueForTag(this.itemNode, "http://www.w3.org/ns/widgets", "description", description);
    }

    public void setViewmodes(String viewmodes) {
        this.viewmodes.setValue(viewmodes);
        this.setAttributeValue(this.itemNode, null, "viewmodes", viewmodes);
    }

    public void setAuthor(Author author) {
        this.setTagObject(author, this.author);
        this.author.setValue(author);
    }

    public void setContent(Content content) {
        this.setTagObject(content, this.content);
        this.content.setValue(content);
    }

    public void setLicense(License license) {
        this.setTagObject(license, this.license);
        this.license.setValue(license);
    }

    public void addPreference(Preference preference) {
        this.addItem(preference, this.preferences);
    }

    public void addAccess(Access access) {
        this.addItem(access, this.accesses);
    }

    public void addFeature(Feature feature) {
        this.addItem(feature, this.features);
    }

    public void addIcon(Icon icon) {
        this.addItem(icon, this.icons);
    }

    public void addSplash(Splash splash) {
        this.addItem(splash, this.splashes);
    }

    public void addEngine(Engine engine) {
        this.addItem(engine, this.engines);
    }

    public void addPlugin(Plugin plugin) {
        this.addItem(plugin, this.plugins);
    }

    public void removePreference(Preference preference) {
        this.removeItem(preference, this.preferences);
    }

    public void removeAccess(Access access) {
        this.removeItem(access, this.accesses);
    }

    public void removeFeature(Feature feature) {
        this.removeItem(feature, this.features);
    }

    public void removeIcon(Icon icon) {
        this.removeItem(icon, this.icons);
    }

    public void removeSplash(Splash splash) {
        this.removeItem(splash, this.splashes);
    }

    public void removeEngine(Engine engine) {
        this.removeItem(engine, this.engines);
    }

    public void removePlugin(Plugin plugin) {
        this.removeItem(plugin, this.plugins);
    }

    private <T extends AbstractConfigObject> void removeItem(T object, AbstractConfigObject.Property<List<T>> property) {
        Node removed;
        if (object == null) {
            return;
        }
        List<T> oldList = property.getValue();
        if (oldList.contains(object) && (removed = this.itemNode.removeChild(object.itemNode)) != null) {
            ArrayList<T> list = new ArrayList<T>(oldList);
            list.remove(object);
            property.setValue(list);
        }
    }

    private <T extends AbstractConfigObject> void addItem(T object, AbstractConfigObject.Property<List<T>> property) {
        if (object == null) {
            return;
        }
        ArrayList<T> objects = new ArrayList<T>();
        if (property.getValue() == null || property.getValue().isEmpty()) {
            Node newNode = this.itemNode.appendChild(object.itemNode);
            if (newNode != null) {
                objects.add(object);
            }
        } else {
            objects.addAll((Collection)property.getValue());
            Node ref = ((AbstractConfigObject)objects.get((int)(objects.size() - 1))).itemNode.getNextSibling();
            Node newNode = this.itemNode.insertBefore(object.itemNode, ref);
            if (newNode != null) {
                objects.add(object);
            }
        }
        property.setValue(objects);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Widget)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Widget that = (Widget)obj;
        return this.equalField(that.getId(), this.getId()) && this.equalField(that.getVersion(), this.getVersion());
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.getId() != null) {
            hash *= this.getId().hashCode();
        }
        if (this.getVersion() != null) {
            hash *= this.getVersion().hashCode();
        }
        return hash;
    }

    private <T extends AbstractConfigObject> void setTagObject(T object, AbstractConfigObject.Property<T> prop) {
        if (object == null) {
            this.itemNode.removeChild(((AbstractConfigObject)prop.getValue()).itemNode);
        } else if (prop.getValue() == null) {
            this.itemNode.appendChild(object.itemNode);
        } else {
            this.itemNode.replaceChild(object.itemNode, ((AbstractConfigObject)prop.getValue()).itemNode);
        }
    }
}

