/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import com.github.zafarkhaja.semver.Version;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.AbstractEngineRepoProvider;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineLocator;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.engine.internal.cordova.EngineDownloadReceiver;
import org.eclipse.thym.core.engine.internal.cordova.NpmBasedEngineRepoProvider;
import org.eclipse.thym.core.extensions.CordovaEngineRepoProvider;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.EngineUtils;
import org.osgi.service.prefs.BackingStoreException;

public class CordovaEngineProvider
implements HybridMobileEngineLocator,
HybridMobileEngineLocator.EngineSearchListener {
    public static final String CORDOVA_ENGINE_ID = "cordova";
    public static final String CUSTOM_CORDOVA_ENGINE_ID = "custom_cordova";
    private static volatile Set<HybridMobileEngine> engineList;
    private static CordovaEngineProvider instance;

    private CordovaEngineProvider() {
    }

    public static CordovaEngineProvider getInstance() {
        if (instance == null) {
            instance = new CordovaEngineProvider();
        }
        return instance;
    }

    private void initEngineList() {
        if (engineList == null) {
            engineList = new LinkedHashSet<HybridMobileEngine>();
            List<DownloadableCordovaEngine> downloadableEngines = null;
            List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
            for (PlatformSupport support : platforms) {
                DownloadableCordovaEngine latestEngine;
                try {
                    downloadableEngines = this.getDownloadableEngines(support.getPlatformId());
                }
                catch (CoreException e) {
                    HybridCore.log(4, "Error retrieving downloadable engines", e);
                }
                if (downloadableEngines == null || (latestEngine = this.getLatestVersion(downloadableEngines)) == null) continue;
                engineList.add(this.createEngine(latestEngine.getPlatformId(), latestEngine.getVersion()));
            }
            engineList.addAll(this.getPreferencesEngines());
        }
    }

    public Set<HybridMobileEngine> getAvailableEngines() {
        this.initEngineList();
        return engineList;
    }

    private void resetEngineList() {
        engineList = null;
    }

    public String getName() {
        return "Apache Cordova";
    }

    public HybridMobileEngine getEngine(String name, String spec) {
        this.initEngineList();
        for (HybridMobileEngine engine : engineList) {
            if (!EngineUtils.getExactVersion(engine.getSpec()).equals(EngineUtils.getExactVersion(spec)) || !engine.getName().equals(name)) continue;
            return engine;
        }
        return null;
    }

    public static IPath getLibFolder() {
        Path path = new Path(FileUtils.getUserDirectory().toString());
        path = path.append(".cordova").append("lib");
        return path;
    }

    public List<DownloadableCordovaEngine> getDownloadableEngines() throws CoreException {
        AbstractEngineRepoProvider provider = new NpmBasedEngineRepoProvider();
        IProduct product = Platform.getProduct();
        if (product != null) {
            String productId = Platform.getProduct().getId();
            List<CordovaEngineRepoProvider> providerProxies = HybridCore.getCordovaEngineRepoProviders();
            for (CordovaEngineRepoProvider providerProxy : providerProxies) {
                if (!productId.equals(providerProxy.getProductId())) continue;
                provider = providerProxy.createProvider();
            }
        }
        return ((AbstractEngineRepoProvider)provider).getEngines();
    }

    public List<DownloadableCordovaEngine> getDownloadableEngines(String platformId) throws CoreException {
        AbstractEngineRepoProvider provider = new NpmBasedEngineRepoProvider();
        IProduct product = Platform.getProduct();
        if (product != null) {
            String productId = Platform.getProduct().getId();
            List<CordovaEngineRepoProvider> providerProxies = HybridCore.getCordovaEngineRepoProviders();
            for (CordovaEngineRepoProvider providerProxy : providerProxies) {
                if (!productId.equals(providerProxy.getProductId())) continue;
                provider = providerProxy.createProvider();
            }
        }
        return ((AbstractEngineRepoProvider)provider).getEngines(platformId);
    }

    private DownloadableCordovaEngine getLatestVersion(List<DownloadableCordovaEngine> engines) {
        if (engines == null || engines.isEmpty()) {
            return null;
        }
        ArrayList<DownloadableCordovaEngine> stableEngines = new ArrayList<DownloadableCordovaEngine>();
        for (DownloadableCordovaEngine e : engines) {
            if (e.isNightlyBuild()) continue;
            stableEngines.add(e);
        }
        Collections.sort(stableEngines, new VersionComparator());
        return (DownloadableCordovaEngine)stableEngines.get(0);
    }

    public DownloadableCordovaEngine getLatestVersion(String platformId) {
        List<DownloadableCordovaEngine> downloadableEngines = null;
        try {
            downloadableEngines = this.getDownloadableEngines(platformId);
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error while retrieving downloadable engines", e);
        }
        if (downloadableEngines != null) {
            return this.getLatestVersion(downloadableEngines);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadEngine(DownloadableCordovaEngine[] engines, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRetrieveFileTransfer transfer = HybridCore.getDefault().getFileTransferService();
        int platformSize = engines.length;
        Object lock = new Object();
        int incompleteCount = platformSize;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)platformSize);
        int i = 0;
        while (i < platformSize) {
            sm.setTaskName("Download Cordova Engine " + engines[i].getVersion());
            try {
                URI uri = URI.create(engines[i].getDownloadURL());
                IFileID remoteFileID = FileIDFactory.getDefault().createFileID(transfer.getRetrieveNamespace(), uri);
                if (sm.isCanceled()) {
                    return;
                }
                transfer.sendRetrieveRequest(remoteFileID, (IFileTransferListener)new EngineDownloadReceiver(engines[i].getVersion(), engines[i].getPlatformId(), lock, (IProgressMonitor)sm), null);
            }
            catch (FileCreateException e) {
                HybridCore.log(4, "Engine download file create error", e);
            }
            catch (IncomingFileTransferException e) {
                HybridCore.log(4, "Engine download file transfer error", e);
            }
            ++i;
        }
        Object object = lock;
        synchronized (object) {
            while (incompleteCount > 0) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    HybridCore.log(1, "interrupted while waiting for all engines to download", e);
                }
                --incompleteCount;
                sm.worked(1);
            }
        }
        this.resetEngineList();
    }

    public boolean isSupportedPlatform(String version, String platformId) {
        Assert.isNotNull((Object)platformId);
        Assert.isNotNull((Object)version);
        List<DownloadableCordovaEngine> engines = null;
        try {
            engines = this.getDownloadableEngines();
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error retrieving downloadable engines", e);
        }
        if (engines == null) {
            return false;
        }
        for (DownloadableCordovaEngine downloadable : engines) {
            if (!downloadable.getVersion().equals(version) || !downloadable.getPlatformId().equals(platformId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void searchForRuntimes(IPath path, HybridMobileEngineLocator.EngineSearchListener listener, IProgressMonitor monitor) {
        File root;
        if (path != null && (root = path.toFile()).isDirectory()) {
            this.searchDir(root, listener, monitor);
        }
    }

    private void searchDir(File dir, HybridMobileEngineLocator.EngineSearchListener listener, IProgressMonitor monitor) {
        File[] dirs;
        File packageJson;
        File createScript;
        if (monitor.isCanceled()) {
            return;
        }
        if ("bin".equals(dir.getName()) && (createScript = new File(dir, "create")).exists() && (packageJson = new File(String.valueOf(dir.getParent()) + "/package.json")).exists()) {
            JsonParser parser = new JsonParser();
            JsonReader reader = null;
            try {
                reader = new JsonReader((Reader)new FileReader(packageJson));
            }
            catch (FileNotFoundException e) {
                HybridCore.log(4, "package.json was not found", e);
            }
            JsonObject root = parser.parse(reader).getAsJsonObject();
            String name = root.get("name").getAsString();
            if (name.startsWith("cordova-")) {
                name = name.replace("cordova-", "");
            }
            PlatformSupport support = HybridCore.getPlatformSupport(name);
            try {
                HybridMobileEngine engine = this.createEngine(name, dir.getParent(), support.getLibraryResolver());
                listener.engineFound(engine);
                return;
            }
            catch (CoreException e) {
                HybridCore.log(2, "Error on engine search", e);
            }
        }
        if ((dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            int i = 0;
            while (i < dirs.length) {
                String name;
                if (!(monitor.isCanceled() || (name = dirs[i].getName()).equals("npm_cache") || name.equals("tmp"))) {
                    this.searchDir(dirs[i], listener, monitor);
                }
                ++i;
            }
        }
    }

    @Override
    public void engineFound(HybridMobileEngine engine) {
        this.initEngineList();
        if (engineList.add(engine)) {
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.thym.core");
            preferences.put(engine.getName(), engine.getSpec());
        }
    }

    public List<HybridMobileEngine> defaultEngines() {
        ArrayList<HybridMobileEngine> defaultEngines = new ArrayList<HybridMobileEngine>();
        List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
        for (PlatformSupport support : platforms) {
            DownloadableCordovaEngine latestDownloadable = this.getLatestVersion(support.getPlatformId());
            if (latestDownloadable == null) continue;
            HybridMobileEngine engine = this.createEngine(latestDownloadable.getPlatformId(), latestDownloadable.getVersion());
            defaultEngines.add(engine);
        }
        List<HybridMobileEngine> userEngines = this.getUserDefaultEngines();
        for (HybridMobileEngine userEngine : userEngines) {
            int engineFoundIndex = -1;
            for (HybridMobileEngine e : defaultEngines) {
                if (!e.getName().equals(userEngine.getName())) continue;
                engineFoundIndex = defaultEngines.indexOf(e);
                break;
            }
            if (engineFoundIndex != -1) {
                defaultEngines.remove(engineFoundIndex);
            }
            defaultEngines.add(userEngine);
        }
        return defaultEngines;
    }

    private List<HybridMobileEngine> getUserDefaultEngines() {
        ArrayList<HybridMobileEngine> userEngines = new ArrayList<HybridMobileEngine>();
        String pref = Platform.getPreferencesService().getString("org.eclipse.thym.ui", "default_engine", null, null);
        if (pref != null && !pref.isEmpty()) {
            String[] engineStrings;
            String[] stringArray = engineStrings = pref.split(",");
            int n = engineStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String engineString = stringArray[n2];
                String[] engineInfo = engineString.split(":");
                HybridMobileEngine engine = this.createEngine(engineInfo[0], engineInfo[1]);
                userEngines.add(engine);
                ++n2;
            }
        }
        return userEngines;
    }

    private List<HybridMobileEngine> getPreferencesEngines() {
        ArrayList<HybridMobileEngine> preferencesEngines = new ArrayList<HybridMobileEngine>();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.thym.core");
        try {
            String[] stringArray = preferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = preferences.get(key, "");
                preferencesEngines.add(this.createEngine(key, value));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return preferencesEngines;
    }

    public HybridMobileEngine createEngine(String name, String spec) {
        HybridMobileEngine existingEngine = this.getEngine(name, spec);
        if (existingEngine != null) {
            return existingEngine;
        }
        PlatformSupport support = HybridCore.getPlatformSupport(name);
        if (support == null) {
            return new HybridMobileEngine(name, spec, null);
        }
        try {
            return new HybridMobileEngine(name, spec, support.getLibraryResolver());
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error occured when getting library resolver", e);
            return null;
        }
    }

    public HybridMobileEngine createEngine(String name, String spec, HybridMobileLibraryResolver resolver) {
        HybridMobileEngine existingEngine = this.getEngine(name, spec);
        if (existingEngine != null) {
            return existingEngine;
        }
        return new HybridMobileEngine(name, spec, resolver);
    }

    public void deleteEngine(HybridMobileEngine engine) {
        engineList.remove(engine);
    }

    private class VersionComparator
    implements Comparator<DownloadableCordovaEngine> {
        private VersionComparator() {
        }

        @Override
        public int compare(DownloadableCordovaEngine o1, DownloadableCordovaEngine o2) {
            Version v1 = Version.valueOf((String)o1.getVersion());
            Version v2 = Version.valueOf((String)o2.getVersion());
            return v2.compareTo(v1);
        }
    }
}

