/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.AbstractEngineRepoProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.HttpUtil;

public class NpmBasedEngineRepoProvider
extends AbstractEngineRepoProvider {
    private static final String NPM_URL = "https://registry.npmjs.org/cordova-{0}";

    @Override
    public List<DownloadableCordovaEngine> getEngines() throws CoreException {
        List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
        ArrayList<DownloadableCordovaEngine> allEngines = new ArrayList<DownloadableCordovaEngine>();
        for (PlatformSupport support : platforms) {
            allEngines.addAll(this.getEngines(support.getPlatformId()));
        }
        return allEngines;
    }

    @Override
    public List<DownloadableCordovaEngine> getEngines(String engineId) throws CoreException {
        List<DownloadableCordovaEngine> platEngines = this.getPlatformEngines(engineId);
        if (platEngines == null) {
            return new ArrayList<DownloadableCordovaEngine>();
        }
        return platEngines;
    }

    private List<DownloadableCordovaEngine> getPlatformEngines(String platformId) throws CoreException {
        try {
            InputStream stream = HttpUtil.getHttpStream(NLS.bind((String)NPM_URL, (Object)platformId));
            return this.parseEngines(stream, platformId);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Could not retrieve and parse downloadable platform information for ({0})", (Object)platformId), (Throwable)e));
        }
    }

    private List<DownloadableCordovaEngine> parseEngines(InputStream stream, String platformId) throws IOException, CoreException {
        ArrayList<DownloadableCordovaEngine> engines = new ArrayList<DownloadableCordovaEngine>();
        try (JsonReader reader = null;){
            reader = new JsonReader((Reader)new InputStreamReader(stream));
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(reader);
            if (!jsonElement.isJsonObject()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "cannot parse object bacuse it is not a Json object"));
            }
            JsonObject root = jsonElement.getAsJsonObject();
            JsonElement element = root.get("versions");
            JsonObject topVersions = element.getAsJsonObject();
            Set versions = topVersions.entrySet();
            for (Map.Entry entry : versions) {
                JsonObject v = ((JsonElement)entry.getValue()).getAsJsonObject();
                DownloadableCordovaEngine engine = new DownloadableCordovaEngine();
                engine.setVersion(v.get("version").getAsString());
                engine.setPlatformId(platformId);
                JsonObject dist = v.get("dist").getAsJsonObject();
                engine.setDownloadURL(dist.get("tarball").getAsString());
                engines.add(engine);
            }
        }
        return engines;
    }
}

