/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.cordova;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.cordova.CordovaCLI;
import org.eclipse.thym.core.internal.cordova.CordovaCLIResult;
import org.eclipse.thym.core.internal.cordova.CordovaCLIStreamListener;

public class CordovaProjectCLI
extends CordovaCLI {
    public static final String OPTION_NO_SAVE = "--nosave";
    public static final String OPTION_SAVE = "--save";
    private static final String P_COMMAND_PLUGIN = "plugin";
    private static final String P_COMMAND_PLATFORM = "platform";
    private static final String P_COMMAND_PREPARE = "prepare";
    private static final String P_COMMAND_EMULATE = "emulate";
    private static final String P_COMMAND_RUN = "run";
    private static final String P_COMMAND_BUILD = "build";
    private static Map<String, Lock> projectLock = Collections.synchronizedMap(new HashMap());
    private HybridProject project;

    public static CordovaProjectCLI newCLIforProject(HybridProject project) {
        if (project == null) {
            throw new IllegalArgumentException("No project specified");
        }
        return new CordovaProjectCLI(project);
    }

    private CordovaProjectCLI(HybridProject project) {
        this.project = project;
    }

    public CordovaCLIResult build(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova build"));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_BUILD, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult prepare(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova prepare "));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_PREPARE, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult emulate(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova emulate"));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_EMULATE, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult run(IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova run"));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_RUN, null, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult platform(Command command, IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova platform " + command.getCliCommand()));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_PLATFORM, command, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult plugin(Command command, IProgressMonitor monitor, String ... options) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova plugin " + command.getCliCommand()));
        String cordovaCommand = this.generateCordovaCommand(P_COMMAND_PLUGIN, command, options);
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    @Override
    protected void sendCordovaCommand(IProcess process, String cordovaCommand, IProgressMonitor monitor) throws CoreException {
        Lock lock = this.projectLock();
        lock.lock();
        try {
            super.sendCordovaCommand(process, cordovaCommand, monitor);
        }
        finally {
            lock.unlock();
        }
    }

    private Lock projectLock() {
        String projectName = this.project.getProject().getName();
        Lock l = projectLock.get(this.project.getProject().getName());
        if (l == null) {
            l = new ReentrantLock();
            projectLock.put(projectName, l);
        }
        return l;
    }

    @Override
    protected File getWorkingDirectory() {
        IPath wp = this.project.getProject().getLocation();
        if (wp == null) {
            return null;
        }
        return wp.toFile();
    }

    private String generateCordovaCommand(String command, Command subCommand, String ... options) {
        StringBuilder builder = new StringBuilder();
        builder.append("cordova");
        if (command != null) {
            builder.append(" ");
            builder.append(command);
        }
        if (subCommand != null) {
            builder.append(" ");
            builder.append(subCommand.getCliCommand());
        }
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!string.isEmpty()) {
                builder.append(" ");
                builder.append(string);
            }
            ++n2;
        }
        builder.append("\n");
        return builder.toString();
    }

    public static enum Command {
        ADD("add"),
        REMOVE("remove"),
        UPDATE("update"),
        LIST("list");

        private final String cliCommand;

        private Command(String cli) {
            this.cliCommand = cli;
        }

        public String getCliCommand() {
            return this.cliCommand;
        }
    }
}

