/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.TracingStreamListener;

public class ExternalProcessUtility {
    public void execAsync(String[] command, File workingDirectory, IStreamListener outStreamListener, IStreamListener errorStreamListener, String[] envp) throws CoreException {
        HybridCore.trace("Async Execute command line: " + Arrays.toString(command));
        this.exec(command, workingDirectory, (IProgressMonitor)new NullProgressMonitor(), envp, null, outStreamListener, errorStreamListener);
    }

    public void execAsync(String commandLine, File workingDirectory, IStreamListener outStreamListener, IStreamListener errorStreamListener, String[] envp) throws CoreException {
        this.checkCommandLine(commandLine);
        this.execAsync(DebugPlugin.parseArguments((String)commandLine), workingDirectory, outStreamListener, errorStreamListener, envp);
    }

    /*
     * Unable to fully structure code
     */
    public int execSync(String[] command, File workingDirectory, IStreamListener outStreamListener, IStreamListener errorStreamListener, IProgressMonitor monitor, String[] envp, ILaunchConfiguration launchConfiguration) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        HybridCore.trace("Sync Execute command line: " + Arrays.toString(command));
        prcs = this.exec(command, workingDirectory, monitor, envp, launchConfiguration, outStreamListener, errorStreamListener);
        if (prcs != null) ** GOTO lbl15
        return 0;
lbl-1000:
        // 1 sources

        {
            try {
                if (monitor.isCanceled()) {
                    prcs.terminate();
                    break;
                }
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                HybridCore.log(1, "Exception waiting for process to terminate", e);
            }
lbl15:
            // 3 sources

            ** while (!prcs.isTerminated())
        }
lbl16:
        // 2 sources

        return prcs.getExitValue();
    }

    public IProcess exec(String[] command, File workingDirectory, IProgressMonitor monitor, String[] envp, ILaunchConfiguration launchConfiguration, IStreamListener outStreamListener, IStreamListener errorStreamListener) throws CoreException {
        this.checkCommands(command);
        this.checkWorkingDirectory(workingDirectory);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (envp == null && launchConfiguration != null) {
            envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(launchConfiguration);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        Process process = DebugPlugin.exec((String[])command, (File)workingDirectory, (String[])envp);
        Map<String, String> processAttributes = this.generateProcessAttributes(command, launchConfiguration);
        Launch launch = new Launch(launchConfiguration, "run", null);
        IProcess prcs = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)command[0], processAttributes);
        this.setTracing(command, outStreamListener, errorStreamListener, prcs);
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        return prcs;
    }

    public int execSync(String commandLine, File workingDirectory, IStreamListener outStreamListener, IStreamListener errorStreamListener, IProgressMonitor monitor, String[] envp, ILaunchConfiguration launchConfiguration) throws CoreException {
        String[] cmd = DebugPlugin.parseArguments((String)commandLine);
        return this.execSync(cmd, workingDirectory, outStreamListener, errorStreamListener, monitor, envp, launchConfiguration);
    }

    private Map<String, String> generateProcessAttributes(String[] command, ILaunchConfiguration launchConfiguration) throws CoreException {
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, command[0]);
        processAttributes.put(IProcess.ATTR_CMDLINE, this.generateCommandLine(command));
        if (launchConfiguration != null) {
            processAttributes.put(IProcess.ATTR_PROCESS_LABEL, launchConfiguration.getAttribute(IProcess.ATTR_PROCESS_LABEL, command[0]));
        }
        return processAttributes;
    }

    private void checkWorkingDirectory(File workingDirectory) {
        if (workingDirectory != null && !workingDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(workingDirectory.toString()) + " is not a valid directory");
        }
    }

    private void setTracing(String[] command, IStreamListener outStreamListener, IStreamListener errorStreamListener, IProcess prcs) {
        if (HybridCore.DEBUG) {
            HybridCore.trace("Creating TracingStreamListeners for " + Arrays.toString(command));
            outStreamListener = new TracingStreamListener(outStreamListener);
            errorStreamListener = new TracingStreamListener(outStreamListener);
        }
        if (outStreamListener != null) {
            prcs.getStreamsProxy().getOutputStreamMonitor().addListener(outStreamListener);
            outStreamListener.streamAppended(prcs.getStreamsProxy().getOutputStreamMonitor().getContents(), null);
        }
        if (errorStreamListener != null) {
            prcs.getStreamsProxy().getErrorStreamMonitor().addListener(errorStreamListener);
            errorStreamListener.streamAppended(prcs.getStreamsProxy().getErrorStreamMonitor().getContents(), null);
        }
    }

    private void checkCommandLine(String commandLine) {
        if (commandLine == null || commandLine.isEmpty()) {
            throw new IllegalArgumentException("Missing command line");
        }
    }

    private void checkCommands(String[] command) {
        if (command == null || command.length < 1) {
            throw new IllegalArgumentException("Empty commands array");
        }
    }

    private String generateCommandLine(String[] commandLine) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
            } else {
                buf.append(command);
            }
            ++i;
        }
        return buf.toString();
    }
}

