/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.BundleHttpCacheStorage;

public class HttpUtil {
    public static InputStream getHttpStream(String url) throws IOException {
        URI target = URI.create(url);
        CloseableHttpClient client = HttpUtil.getHttpClient(target);
        HttpGet get = new HttpGet(target);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        HttpEntity entity = response.getEntity();
        StatusLine line = response.getStatusLine();
        if (line.getStatusCode() != 200) {
            throw new IOException("HTTP response status is " + line.getStatusCode());
        }
        return entity.getContent();
    }

    private static CloseableHttpClient getHttpClient(URI url) {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(122880L).setHeuristicCachingEnabled(true).setHeuristicDefaultLifetime(TimeUnit.HOURS.toSeconds(12L)).build();
        CachingHttpClientBuilder builder = CachingHttpClients.custom().setCacheConfig(cacheConfig).setHttpCacheStorage((HttpCacheStorage)new BundleHttpCacheStorage(HybridCore.getContext().getBundle()));
        builder = HttpUtil.setupProxy(builder, url);
        return builder.build();
    }

    private static CachingHttpClientBuilder setupProxy(CachingHttpClientBuilder builder, URI url) {
        IProxyData[] proxies;
        IProxyService proxyService = HybridCore.getDefault().getProxyService();
        if (proxyService != null && (proxies = proxyService.select(url)) != null && proxies.length > 0) {
            IProxyData proxy = proxies[0];
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            if (proxy.isRequiresAuthentication()) {
                credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUserId(), proxy.getPassword()));
            }
            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            builder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort()));
        }
        return builder;
    }
}

